/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.permission;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.authorization.permission.entity.JpaPermissionEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaPermissionModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaPermissionEntity, PermissionTicket, JpaPermissionModelCriteriaBuilder> {
    public JpaPermissionModelCriteriaBuilder() {
        super(JpaPermissionModelCriteriaBuilder::new);
    }

    private JpaPermissionModelCriteriaBuilder(JpaPredicateFunction<JpaPermissionEntity> predicateFunc) {
        super(JpaPermissionModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaPermissionModelCriteriaBuilder compare(SearchableModelField<? super PermissionTicket> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == PermissionTicket.SearchableFields.ID || modelField == PermissionTicket.SearchableFields.SCOPE_ID || modelField == PermissionTicket.SearchableFields.POLICY_ID || modelField == PermissionTicket.SearchableFields.RESOURCE_ID || modelField == PermissionTicket.SearchableFields.RESOURCE_SERVER_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.get(modelField.getName()), (Object)uuid);
                    });
                }
                if (modelField == PermissionTicket.SearchableFields.REALM_ID || modelField == PermissionTicket.SearchableFields.OWNER || modelField == PermissionTicket.SearchableFields.REQUESTER) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case EXISTS: {
                if (modelField == PermissionTicket.SearchableFields.SCOPE_ID || modelField == PermissionTicket.SearchableFields.REQUESTER) {
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.isNotNull((Expression)root.get(modelField.getName())));
                }
                if (modelField == PermissionTicket.SearchableFields.GRANTED_TIMESTAMP) {
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.isNotNull(cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fGrantedTimestamp")})));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField == PermissionTicket.SearchableFields.SCOPE_ID || modelField == PermissionTicket.SearchableFields.REQUESTER) {
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.isNull((Expression)root.get(modelField.getName())));
                }
                if (modelField == PermissionTicket.SearchableFields.GRANTED_TIMESTAMP) {
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.isNull(cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fGrantedTimestamp")})));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == PermissionTicket.SearchableFields.RESOURCE_ID) {
                    Set<UUID> uuids = this.getUuidsForInOperator(value, modelField);
                    if (uuids.isEmpty()) {
                        return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPermissionModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get(modelField.getName()));
                        uuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

