/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.userSession.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaClientSessionEntity;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionMetadata;
import org.keycloak.models.map.storage.jpa.userSession.entity.JpaUserSessionNoteEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

@Entity
@Table(name="kc_user_session")
@EnhancementInfo(version="6.2.5.Final")
public class JpaUserSessionEntity
extends MapUserSessionEntity.AbstractUserSessionEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaUserSessionMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String userId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String brokerSessionId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String brokerUserId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Boolean offline;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Long lastSessionRefresh;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Long expiration;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaUserSessionNoteEntity> notes = new HashSet<JpaUserSessionNoteEntity>();
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaClientSessionEntity> clientSessions = new HashSet<JpaClientSessionEntity>();
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaUserSessionEntity() {
        this.metadata = new JpaUserSessionMetadata();
    }

    public JpaUserSessionEntity(DeepCloner cloner) {
        this.metadata = new JpaUserSessionMetadata(cloner);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_USER_SESSION;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getUserId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getUserId();
        }
        return this.$$_hibernate_read_userId();
    }

    public void setUserId(String userId) {
        this.$$_hibernate_read_metadata().setUserId(userId);
    }

    public String getLoginUsername() {
        return this.$$_hibernate_read_metadata().getLoginUsername();
    }

    public void setLoginUsername(String loginUsername) {
        this.$$_hibernate_read_metadata().setLoginUsername(loginUsername);
    }

    public String getIpAddress() {
        return this.$$_hibernate_read_metadata().getIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.$$_hibernate_read_metadata().setIpAddress(ipAddress);
    }

    public String getAuthMethod() {
        return this.$$_hibernate_read_metadata().getAuthMethod();
    }

    public void setAuthMethod(String authMethod) {
        this.$$_hibernate_read_metadata().setAuthMethod(authMethod);
    }

    public Boolean isOffline() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().isOffline();
        }
        return this.$$_hibernate_read_offline();
    }

    public void setOffline(Boolean offline) {
        this.$$_hibernate_read_metadata().setOffline(offline);
    }

    public Boolean isRememberMe() {
        return this.$$_hibernate_read_metadata().isRememberMe();
    }

    public void setRememberMe(Boolean rememberMe) {
        this.$$_hibernate_read_metadata().setRememberMe(rememberMe);
    }

    public Long getTimestamp() {
        return this.$$_hibernate_read_metadata().getTimestamp();
    }

    public void setTimestamp(Long timestamp) {
        this.$$_hibernate_read_metadata().setTimestamp(timestamp);
    }

    public Long getLastSessionRefresh() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getLastSessionRefresh();
        }
        return this.$$_hibernate_read_lastSessionRefresh();
    }

    public void setLastSessionRefresh(Long lastSessionRefresh) {
        this.$$_hibernate_read_metadata().setLastSessionRefresh(lastSessionRefresh);
    }

    public Long getExpiration() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getExpiration();
        }
        return this.$$_hibernate_read_expiration();
    }

    public void setExpiration(Long expiration) {
        this.$$_hibernate_read_metadata().setExpiration(expiration);
    }

    public UserSessionModel.State getState() {
        return this.$$_hibernate_read_metadata().getState();
    }

    public void setState(UserSessionModel.State state) {
        this.$$_hibernate_read_metadata().setState(state);
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return UserSessionModel.SessionPersistenceState.PERSISTENT;
    }

    public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
    }

    public Map<String, String> getNotes() {
        return Collections.unmodifiableMap(this.$$_hibernate_read_notes().stream().collect(Collectors.toMap(JpaAttributeEntity::getName, JpaAttributeEntity::getValue)));
    }

    public String getNote(String name) {
        return this.$$_hibernate_read_notes().stream().filter(obj -> Objects.equals(obj.getName(), name)).findFirst().map(JpaAttributeEntity::getValue).orElse(null);
    }

    public void setNotes(Map<String, String> notes) {
        this.$$_hibernate_read_notes().clear();
        if (notes == null) {
            return;
        }
        for (Map.Entry<String, String> entry : notes.entrySet()) {
            this.setNote(entry.getKey(), entry.getValue());
        }
    }

    public Boolean removeNote(String name) {
        return this.$$_hibernate_read_notes().removeIf(obj -> Objects.equals(obj.getName(), name));
    }

    public void setNote(String name, String value) {
        this.removeNote(name);
        if (name == null || value == null || value.trim().isEmpty()) {
            return;
        }
        this.$$_hibernate_read_notes().add(new JpaUserSessionNoteEntity(this, name, value));
    }

    public String getBrokerSessionId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getBrokerSessionId();
        }
        return this.$$_hibernate_read_brokerSessionId();
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.$$_hibernate_read_metadata().setBrokerSessionId(brokerSessionId);
    }

    public String getBrokerUserId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getBrokerUserId();
        }
        return this.$$_hibernate_read_brokerUserId();
    }

    public void setBrokerUserId(String brokerUserId) {
        this.$$_hibernate_read_metadata().setBrokerUserId(brokerUserId);
    }

    public Set<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSessions() {
        return this.$$_hibernate_read_clientSessions().stream().map(MapAuthenticatedClientSessionEntity.class::cast).collect(Collectors.toSet());
    }

    public void addAuthenticatedClientSession(MapAuthenticatedClientSessionEntity clientSession) {
        JpaClientSessionEntity jpaClientSession = (JpaClientSessionEntity)JpaClientSessionEntity.class.cast(JpaMapStorageProviderFactory.CLONER.from((Object)clientSession));
        jpaClientSession.setParent(this);
        jpaClientSession.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_CLIENT_SESSION);
        this.$$_hibernate_read_clientSessions().add(jpaClientSession);
    }

    public Optional<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSession(String clientUUID) {
        return this.$$_hibernate_read_clientSessions().stream().filter(cs -> Objects.equals(cs.getClientId(), clientUUID)).findFirst().map(MapAuthenticatedClientSessionEntity.class::cast);
    }

    public Boolean removeAuthenticatedClientSession(String clientUUID) {
        return this.$$_hibernate_read_clientSessions().removeIf(cs -> Objects.equals(cs.getClientId(), clientUUID));
    }

    public void clearAuthenticatedClientSessions() {
        this.$$_hibernate_read_clientSessions().clear();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaUserSessionEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaUserSessionEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaUserSessionMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaUserSessionMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_userId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "userId", (Object)this.userId);
        }
        return this.userId;
    }

    public void $$_hibernate_write_userId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userId", (Object)this.userId, (Object)string);
            return;
        }
        this.userId = string;
    }

    public String $$_hibernate_read_brokerSessionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.brokerSessionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "brokerSessionId", (Object)this.brokerSessionId);
        }
        return this.brokerSessionId;
    }

    public void $$_hibernate_write_brokerSessionId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.brokerSessionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "brokerSessionId", (Object)this.brokerSessionId, (Object)string);
            return;
        }
        this.brokerSessionId = string;
    }

    public String $$_hibernate_read_brokerUserId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.brokerUserId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "brokerUserId", (Object)this.brokerUserId);
        }
        return this.brokerUserId;
    }

    public void $$_hibernate_write_brokerUserId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.brokerUserId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "brokerUserId", (Object)this.brokerUserId, (Object)string);
            return;
        }
        this.brokerUserId = string;
    }

    public Boolean $$_hibernate_read_offline() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "offline", (Object)this.offline);
        }
        return this.offline;
    }

    public void $$_hibernate_write_offline(Boolean bl) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "offline", (Object)this.offline, (Object)bl);
            return;
        }
        this.offline = bl;
    }

    public Long $$_hibernate_read_lastSessionRefresh() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastSessionRefresh = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastSessionRefresh", (Object)this.lastSessionRefresh);
        }
        return this.lastSessionRefresh;
    }

    public void $$_hibernate_write_lastSessionRefresh(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastSessionRefresh = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastSessionRefresh", (Object)this.lastSessionRefresh, (Object)l);
            return;
        }
        this.lastSessionRefresh = l;
    }

    public Long $$_hibernate_read_expiration() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expiration = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "expiration", (Object)this.expiration);
        }
        return this.expiration;
    }

    public void $$_hibernate_write_expiration(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expiration = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "expiration", (Object)this.expiration, (Object)l);
            return;
        }
        this.expiration = l;
    }

    public Set $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", this.notes);
        }
        return this.notes;
    }

    public Set $$_hibernate_read_clientSessions() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientSessions = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientSessions", this.clientSessions);
        }
        return this.clientSessions;
    }
}

