/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authSession;

import java.sql.Connection;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntityDelegate;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaMapStorage;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.authSession.JpaRootAuthenticationSessionModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.authSession.delegate.JpaRootAuthenticationSessionDelegateProvider;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaRootAuthenticationSessionEntity;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class JpaRootAuthenticationSessionMapStorage
extends JpaMapStorage<JpaRootAuthenticationSessionEntity, MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> {
    public JpaRootAuthenticationSessionMapStorage(KeycloakSession session, EntityManager em) {
        super(session, JpaRootAuthenticationSessionEntity.class, RootAuthenticationSessionModel.class, em);
    }

    @Override
    public Selection<JpaRootAuthenticationSessionEntity> selectCbConstruct(CriteriaBuilder cb, Root<JpaRootAuthenticationSessionEntity> root) {
        return cb.construct(JpaRootAuthenticationSessionEntity.class, new Selection[]{root.get("id"), root.get("version"), root.get("entityVersion"), root.get("realmId"), root.get("timestamp"), root.get("expiration")});
    }

    @Override
    public void setEntityVersion(JpaRootEntity entity) {
        entity.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_AUTH_SESSION);
    }

    @Override
    public JpaModelCriteriaBuilder createJpaModelCriteriaBuilder() {
        return new JpaRootAuthenticationSessionModelCriteriaBuilder();
    }

    @Override
    protected MapRootAuthenticationSessionEntity mapToEntityDelegate(JpaRootAuthenticationSessionEntity original) {
        return new MapRootAuthenticationSessionEntityDelegate((DelegateProvider)new JpaRootAuthenticationSessionDelegateProvider(original, this.em));
    }

    @Override
    public boolean delete(String key) {
        int isolationLevel = (Integer)((Session)this.em.unwrap(Session.class)).doReturningWork(Connection::getTransactionIsolation);
        if (isolationLevel == 8) {
            if (key == null) {
                return false;
            }
            UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(key);
            if (uuid == null) {
                return false;
            }
            this.removeFromCache(key);
            JpaRootAuthenticationSessionEntity rootAuth = (JpaRootAuthenticationSessionEntity)this.em.getReference(JpaRootAuthenticationSessionEntity.class, (Object)uuid);
            Query deleteById = this.em.createNamedQuery("deleteRootAuthenticationSessionByIdNoOptimisticLocking");
            ((NativeQuery)deleteById.unwrap(NativeQuery.class)).addSynchronizedQuerySpace(new String[]{"kc_auth_root_session", "kc_auth_session"});
            deleteById.setParameter("id", (Object)key);
            int deleteCount = deleteById.executeUpdate();
            rootAuth.getAuthenticationSessions().forEach(e -> this.em.detach(e));
            this.em.detach((Object)rootAuth);
            if (deleteCount == 1) {
                return true;
            }
            if (deleteCount == 0) {
                throw new ModelException("Unable to find root authentication session");
            }
            throw new ModelException("Deleted " + deleteCount + " root authentication session when expecting to delete one");
        }
        return super.delete(key);
    }
}

