/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client.delegate;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;

public class JpaClientDelegateProvider
extends JpaDelegateProvider<JpaClientEntity>
implements DelegateProvider<MapClientEntity> {
    private final EntityManager em;

    public JpaClientDelegateProvider(JpaClientEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapClientEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapClientEntity>> field, Object ... parameters) {
        if (((JpaClientEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapClientEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapClientEntityFields)) throw new IllegalStateException("Not a valid client field: " + field);
            switch ((MapClientEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case CLIENT_ID: 
                case PROTOCOL: 
                case ENABLED: {
                    return (MapClientEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaClientEntity.class);
                    Root root = query.from(JpaClientEntity.class);
                    root.fetch("attributes", JoinType.LEFT);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaClientEntity)this.getDelegate()).getId())));
                    this.setDelegate((JpaClientEntity)this.em.createQuery(query).getSingleResult());
                    return (MapClientEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaClientEntity)this.em.find(JpaClientEntity.class, (Object)UUID.fromString(((JpaClientEntity)this.getDelegate()).getId())));
                    return (MapClientEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaClientEntity)this.em.find(JpaClientEntity.class, (Object)UUID.fromString(((JpaClientEntity)this.getDelegate()).getId())));
        }
        return (MapClientEntity)this.getDelegate();
    }
}

