/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import javax.persistence.EntityManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaTransactionWrapper;

public class JpaMapStorageProvider
implements MapStorageProvider {
    private final JpaMapStorageProviderFactory factory;
    private final KeycloakSession session;
    private final EntityManager em;
    private final String sessionTxKey;

    public JpaMapStorageProvider(JpaMapStorageProviderFactory factory, KeycloakSession session, EntityManager em, String sessionTxKey) {
        this.factory = factory;
        this.session = session;
        this.em = em;
        this.sessionTxKey = sessionTxKey;
    }

    public void close() {
        this.em.close();
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getStorage(final Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        this.factory.validateAndUpdateSchema(this.session, modelType);
        if (this.session.getAttribute(this.sessionTxKey) == null) {
            JpaTransactionWrapper jpaTransaction = new JpaTransactionWrapper(this.em.getTransaction());
            this.session.getTransactionManager().enlist((KeycloakTransaction)jpaTransaction);
            this.session.setAttribute(this.sessionTxKey, (Object)jpaTransaction);
        }
        return new MapStorage<V, M>(){

            public MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session) {
                return JpaMapStorageProvider.this.factory.createTransaction(session, modelType, JpaMapStorageProvider.this.em);
            }
        };
    }
}

