/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.JpaSubqueryProvider;
import org.keycloak.models.map.storage.jpa.PaginationUtils;
import org.keycloak.utils.LockObjectsForModification;
import org.keycloak.utils.StreamsUtil;

public abstract class JpaMapKeycloakTransaction<RE extends JpaRootEntity, E extends AbstractEntity, M>
implements MapKeycloakTransaction<E, M> {
    private static final Logger logger = Logger.getLogger(JpaMapKeycloakTransaction.class);
    private final KeycloakSession session;
    private final Class<RE> entityType;
    private final Class<M> modelType;
    private final boolean isExpirableEntity;
    protected EntityManager em;
    private final HashMap<String, E> cacheWithinSession = new HashMap();

    public JpaMapKeycloakTransaction(KeycloakSession session, Class<RE> entityType, Class<M> modelType, EntityManager em) {
        this.session = session;
        this.em = em;
        this.entityType = entityType;
        this.modelType = modelType;
        this.isExpirableEntity = ExpirableEntity.class.isAssignableFrom(entityType);
    }

    protected abstract Selection<? extends RE> selectCbConstruct(CriteriaBuilder var1, Root<RE> var2);

    protected abstract void setEntityVersion(JpaRootEntity var1);

    protected abstract JpaModelCriteriaBuilder createJpaModelCriteriaBuilder();

    protected abstract E mapToEntityDelegate(RE var1);

    private E mapToEntityDelegateUnique(RE original) {
        if (original == null) {
            return null;
        }
        Object entity = (AbstractEntity)this.cacheWithinSession.get(original.getId());
        if (entity == null) {
            entity = this.mapToEntityDelegate(original);
            this.cacheWithinSession.put(original.getId(), entity);
        }
        return (E)entity;
    }

    public E create(E mapEntity) {
        JpaRootEntity jpaEntity = (JpaRootEntity)this.entityType.cast(JpaMapStorageProviderFactory.CLONER.from(mapEntity));
        if (mapEntity.getId() == null) {
            jpaEntity.setId(StringKeyConverter.UUIDKey.INSTANCE.yieldNewUniqueKey().toString());
        }
        logger.tracef("tx %d: create entity %s", this.hashCode(), (Object)jpaEntity.getId());
        this.setEntityVersion(jpaEntity);
        this.em.persist((Object)jpaEntity);
        return this.mapToEntityDelegateUnique(jpaEntity);
    }

    public E read(String key) {
        if (key == null) {
            return null;
        }
        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return null;
        }
        E e = this.mapToEntityDelegateUnique(LockObjectsForModification.isEnabled((KeycloakSession)this.session, this.modelType) ? (JpaRootEntity)this.em.find(this.entityType, (Object)uuid, LockModeType.PESSIMISTIC_WRITE) : (JpaRootEntity)this.em.find(this.entityType, (Object)uuid));
        return (E)(e != null && this.isExpirableEntity && ExpirationUtils.isExpired((ExpirableEntity)((ExpirableEntity)e), (boolean)true) ? null : e);
    }

    public Stream<E> read(QueryParameters<M> queryParameters) {
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.entityType);
        Root root = query.from(this.entityType);
        query.select(this.selectCbConstruct(cb, root));
        if (mcb.isDistinct()) {
            query.distinct(true);
        }
        if (!queryParameters.getOrderBy().isEmpty()) {
            LinkedList<Order> orderByList = new LinkedList<Order>();
            block4: for (QueryParameters.OrderBy order : queryParameters.getOrderBy()) {
                switch (order.getOrder()) {
                    case ASCENDING: {
                        orderByList.add(cb.asc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                    case DESCENDING: {
                        orderByList.add(cb.desc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("Unknown ordering.");
            }
            query.orderBy(orderByList);
        }
        JpaPredicateFunction<Object> predicateFunc = mcb.getPredicateFunc();
        if (this.isExpirableEntity) {
            JpaPredicateFunction<Object> jpaPredicateFunction = predicateFunc = predicateFunc != null ? predicateFunc.andThen(predicate -> cb.and((Expression)predicate, (Expression)this.notExpired(cb, arg_0 -> ((CriteriaQuery)query).subquery(arg_0), root))) : this::notExpired;
        }
        if (predicateFunc != null) {
            query.where((Expression)predicateFunc.apply(cb, arg_0 -> ((CriteriaQuery)query).subquery(arg_0), root));
        }
        TypedQuery emQuery = this.em.createQuery(query);
        if (LockObjectsForModification.isEnabled((KeycloakSession)this.session, this.modelType)) {
            emQuery = emQuery.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        }
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(emQuery, queryParameters.getOffset(), queryParameters.getLimit()).getResultStream()).map(this::mapToEntityDelegateUnique);
    }

    public long getCount(QueryParameters<M> queryParameters) {
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(this.entityType);
        countQuery.select((Selection)cb.count((Expression)root));
        JpaPredicateFunction predicateFunc = mcb.getPredicateFunc();
        if (predicateFunc != null) {
            countQuery.where((Expression)predicateFunc.apply(cb, arg_0 -> ((CriteriaQuery)countQuery).subquery(arg_0), root));
        }
        return (Long)this.em.createQuery(countQuery).getSingleResult();
    }

    public boolean delete(String key) {
        if (key == null) {
            return false;
        }
        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return false;
        }
        this.cacheWithinSession.remove(key);
        this.em.remove(this.em.getReference(this.entityType, (Object)uuid));
        logger.tracef("tx %d: delete entity %s", this.hashCode(), (Object)key);
        return true;
    }

    public long delete(QueryParameters<M> queryParameters) {
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        int[] removed = new int[]{0};
        MapModelCriteriaBuilder mapMcb = (MapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilderMap());
        this.cacheWithinSession.entrySet().removeIf(entry -> {
            if (mapMcb.getKeyFilter().test(entry.getKey()) && mapMcb.getEntityFilter().test(entry.getValue())) {
                this.em.remove(this.em.getReference(this.entityType, (Object)StringKeyConverter.UUIDKey.INSTANCE.fromString((String)entry.getKey())));
                removed[0] = removed[0] + 1;
                return true;
            }
            return false;
        });
        CriteriaDelete deleteQuery = cb.createCriteriaDelete(this.entityType);
        Root root = deleteQuery.from(this.entityType);
        JpaPredicateFunction predicateFunc = mcb.getPredicateFunc();
        if (predicateFunc != null) {
            deleteQuery.where((Expression)predicateFunc.apply(cb, arg_0 -> ((CriteriaDelete)deleteQuery).subquery(arg_0), root));
        }
        return this.em.createQuery(deleteQuery).executeUpdate() + removed[0];
    }

    private MapModelCriteriaBuilder<String, E, M> createCriteriaBuilderMap() {
        return new MapModelCriteriaBuilder((StringKeyConverter)StringKeyConverter.StringKey.INSTANCE, MapFieldPredicates.getPredicates(this.modelType));
    }

    public void begin() {
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void setRollbackOnly() {
        this.em.getTransaction().setRollbackOnly();
    }

    public boolean getRollbackOnly() {
        return this.em.getTransaction().getRollbackOnly();
    }

    public boolean isActive() {
        return this.em.getTransaction().isActive();
    }

    private Predicate notExpired(CriteriaBuilder cb, JpaSubqueryProvider query, Root<RE> root) {
        return cb.or((Expression)cb.greaterThan((Expression)root.get("expiration"), (Comparable)Long.valueOf(Time.currentTimeMillis())), (Expression)cb.isNull((Expression)root.get("expiration")));
    }
}

