/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.listeners;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.DefaultAutoFlushEventListener;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JpaAutoFlushListener
extends DefaultAutoFlushEventListener {
    public static final JpaAutoFlushListener INSTANCE = new JpaAutoFlushListener();
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DefaultAutoFlushEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        EventSource source = event.getSession();
        try {
            source.getEventListenerManager().partialFlushStart();
            if (this.flushMightBeNeeded(source)) {
                ActionQueue actionQueue = source.getActionQueue();
                int oldSize = actionQueue.numberOfCollectionRemovals();
                this.flushEverythingToExecutions((FlushEvent)event);
                if (this.flushIsReallyNeeded(event, source)) {
                    LOG.trace((Object)"Need to execute flush");
                    event.setFlushRequired(true);
                    this.performExecutions(source);
                    this.postFlush((SessionImplementor)source);
                    this.postPostFlush((SessionImplementor)source);
                    if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                        source.getFactory().getStatistics().flush();
                    }
                } else {
                    LOG.trace((Object)"Don't need to execute flush");
                    event.setFlushRequired(false);
                    actionQueue.clearFromFlushNeededCheck(oldSize);
                }
            }
        }
        finally {
            source.getEventListenerManager().partialFlushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfEntitiesProcessed());
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source) {
        return source.getHibernateFlushMode() == FlushMode.ALWAYS || source.getActionQueue().numberOfInsertions() > 0 || source.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces());
    }

    private boolean flushMightBeNeeded(EventSource source) {
        return !source.getHibernateFlushMode().lessThan(FlushMode.AUTO) && source.getDontFlushFromFind() == 0 && (source.getPersistenceContext().getNumberOfManagedEntities() > 0 || source.getPersistenceContext().getCollectionEntries().size() > 0);
    }
}

