/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.jsonb;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaAuthenticationSessionMetadata;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaRootAuthenticationSessionMetadata;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientMetadata;
import org.keycloak.models.map.storage.jpa.clientscope.entity.JpaClientScopeMetadata;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaAuthenticationSessionMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaClientMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaClientScopeMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaComponentMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaGroupMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaRealmMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaRoleMigration;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.migration.JpaRootAuthenticationSessionMigration;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaComponentMetadata;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmMetadata;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleMetadata;

public class JpaEntityMigration {
    static final Map<Class<?>, BiFunction<ObjectNode, Integer, ObjectNode>> MIGRATIONS = new HashMap();

    private static ObjectNode migrateTreeTo(int entityVersion, Integer supportedVersion, ObjectNode node, List<Function<ObjectNode, ObjectNode>> migrators) {
        if (entityVersion > supportedVersion + 1) {
            throw new IllegalArgumentException("Incompatible entity version: " + entityVersion + ", supportedVersion: " + supportedVersion);
        }
        if (entityVersion < supportedVersion) {
            while (entityVersion < supportedVersion) {
                Function<ObjectNode, ObjectNode> migrator = migrators.get(entityVersion);
                if (migrator != null) {
                    node = migrator.apply(node);
                }
                ++entityVersion;
            }
        }
        return node;
    }

    static {
        MIGRATIONS.put(JpaAuthenticationSessionMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_AUTH_SESSION, tree, JpaAuthenticationSessionMigration.MIGRATORS));
        MIGRATIONS.put(JpaRootAuthenticationSessionMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_AUTH_SESSION, tree, JpaRootAuthenticationSessionMigration.MIGRATORS));
        MIGRATIONS.put(JpaClientMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_CLIENT, tree, JpaClientMigration.MIGRATORS));
        MIGRATIONS.put(JpaClientScopeMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_CLIENT_SCOPE, tree, JpaClientScopeMigration.MIGRATORS));
        MIGRATIONS.put(JpaComponentMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_REALM, tree, JpaComponentMigration.MIGRATORS));
        MIGRATIONS.put(JpaGroupMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_GROUP, tree, JpaGroupMigration.MIGRATORS));
        MIGRATIONS.put(JpaRealmMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_REALM, tree, JpaRealmMigration.MIGRATORS));
        MIGRATIONS.put(JpaRoleMetadata.class, (tree, entityVersion) -> JpaEntityMigration.migrateTreeTo(entityVersion, Constants.CURRENT_SCHEMA_VERSION_ROLE, tree, JpaRoleMigration.MIGRATORS));
    }
}

