/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import javax.persistence.EntityManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;

public class JpaMapStorageProvider
implements MapStorageProvider {
    private final String SESSION_TX_PREFIX = "jpa-map-tx-";
    private final JpaMapStorageProviderFactory factory;
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaMapStorageProvider(JpaMapStorageProviderFactory factory, KeycloakSession session, EntityManager em) {
        this.factory = factory;
        this.session = session;
        this.em = em;
    }

    public void close() {
        this.em.close();
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getStorage(final Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        this.factory.validateAndUpdateSchema(this.session, modelType);
        return new MapStorage<V, M>(){

            public MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session) {
                MapKeycloakTransaction sessionTx = (MapKeycloakTransaction)session.getAttribute("jpa-map-tx-" + modelType.hashCode(), MapKeycloakTransaction.class);
                if (sessionTx == null) {
                    sessionTx = JpaMapStorageProvider.this.factory.createTransaction(modelType, JpaMapStorageProvider.this.em);
                    session.setAttribute("jpa-map-tx-" + modelType.hashCode(), (Object)sessionTx);
                }
                return sessionTx;
            }
        };
    }
}

