/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.extension;

import java.util.Arrays;
import java.util.stream.Collectors;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;
import org.keycloak.models.map.storage.jpa.liquibase.extension.CreateJsonIndexStatement;
import org.keycloak.models.map.storage.jpa.liquibase.extension.JsonEnabledColumnConfig;

public class CreateJsonIndexGenerator
extends AbstractSqlGenerator<CreateJsonIndexStatement> {
    public int getPriority() {
        return 6;
    }

    public ValidationErrors validate(CreateJsonIndexStatement createIndexStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)createIndexStatement.getTableName());
        validationErrors.checkRequiredField("columns", (Object)createIndexStatement.getColumns());
        Arrays.stream(createIndexStatement.getColumns()).map(JsonEnabledColumnConfig.class::cast).forEach(config -> {
            validationErrors.checkRequiredField("jsonColumn", (Object)config.getJsonColumn());
            validationErrors.checkRequiredField("jsonProperty", (Object)config.getJsonProperty());
        });
        return validationErrors;
    }

    public Sql[] generateSql(CreateJsonIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (!(database instanceof PostgresDatabase)) {
            return new Sql[0];
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (statement.isUnique() != null && statement.isUnique().booleanValue()) {
            builder.append("UNIQUE ");
        }
        builder.append("INDEX ");
        if (statement.getIndexName() != null) {
            builder.append(database.escapeObjectName(statement.getIndexName(), Index.class)).append(" ");
        }
        builder.append("ON ").append(database.escapeTableName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName()));
        this.handleJsonIndex(statement, database, builder);
        if (StringUtil.trimToNull((String)statement.getTablespace()) != null && database.supportsTablespaces()) {
            builder.append(" TABLESPACE ").append(statement.getTablespace());
        }
        return new Sql[]{new UnparsedSql(builder.toString(), new DatabaseObject[]{this.getAffectedIndex(statement)})};
    }

    protected void handleJsonIndex(CreateJsonIndexStatement statement, Database database, StringBuilder builder) {
        if (database instanceof CockroachDatabase) {
            builder.append(" USING gin (");
            builder.append(Arrays.stream(statement.getColumns()).map(JsonEnabledColumnConfig.class::cast).map(c -> "(" + c.getJsonColumn() + "->'" + c.getJsonProperty() + "')").collect(Collectors.joining(", "))).append(")");
        } else if (database instanceof PostgresDatabase) {
            builder.append(" USING gin (");
            builder.append(Arrays.stream(statement.getColumns()).map(JsonEnabledColumnConfig.class::cast).map(c -> "(" + c.getJsonColumn() + "->'" + c.getJsonProperty() + "') jsonb_path_ops").collect(Collectors.joining(", "))).append(")");
        }
    }

    protected Index getAffectedIndex(CreateIndexStatement statement) {
        return new Index().setName(statement.getIndexName()).setTable((Table)new Table().setName(statement.getTableName()).setSchema(statement.getTableCatalogName(), statement.getTableSchemaName()));
    }
}

