/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.role.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleAttributeEntity;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleMetadata;

@Entity
@Table(name="role", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "clientId", "name"})})
@TypeDefs(value={@TypeDef(name="jsonb", typeClass=JsonbType.class)})
public class JpaRoleEntity
extends MapRoleEntity.AbstractRoleEntity
implements JpaRootEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    private UUID id;
    @Version
    @Column
    private int version;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private final JpaRoleMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String clientId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String name;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String description;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private final Set<JpaRoleAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaRoleEntity() {
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_metadata(new JpaRoleMetadata());
    }

    public JpaRoleEntity(DeepCloner cloner) {
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_metadata(new JpaRoleMetadata(cloner));
    }

    public JpaRoleEntity(UUID id, int version, Integer entityVersion, String realmId, String clientId, String name, String description) {
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_clientId(clientId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_description(description);
        this.$$_hibernate_write_metadata(null);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_ROLE;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id == null ? null : UUID.fromString(id));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public String getClientId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getClientId();
        }
        return this.$$_hibernate_read_clientId();
    }

    public String getName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getName();
        }
        return this.$$_hibernate_read_name();
    }

    public String getDescription() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getDescription();
        }
        return this.$$_hibernate_read_description();
    }

    public void setClientRole(Boolean clientRole) {
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_read_metadata().setClientId(clientId);
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public void setDescription(String description) {
        this.$$_hibernate_read_metadata().setDescription(description);
    }

    public Set<String> getCompositeRoles() {
        return this.$$_hibernate_read_metadata().getCompositeRoles();
    }

    public void setCompositeRoles(Set<String> compositeRoles) {
        this.$$_hibernate_read_metadata().setCompositeRoles(compositeRoles);
    }

    public void addCompositeRole(String roleId) {
        this.$$_hibernate_read_metadata().addCompositeRole(roleId);
    }

    public void removeCompositeRole(String roleId) {
        this.$$_hibernate_read_metadata().removeCompositeRole(roleId);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaRoleAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaAttributeEntity::getValue).collect(Collectors.toList());
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        Iterator iterator = this.$$_hibernate_read_attributes().iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        if (attributes != null) {
            for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            JpaRoleAttributeEntity attribute = new JpaRoleAttributeEntity(this, name, value);
            this.$$_hibernate_read_attributes().add(attribute);
        }
    }

    public void removeAttribute(String name) {
        Iterator iterator = this.$$_hibernate_read_attributes().iterator();
        while (iterator.hasNext()) {
            JpaRoleAttributeEntity attr = (JpaRoleAttributeEntity)iterator.next();
            if (!Objects.equals(attr.getName(), name)) continue;
            iterator.remove();
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaRoleEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaRoleEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaRoleMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaRoleMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public void $$_hibernate_write_metadata(JpaRoleMetadata jpaRoleMetadata) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaRoleMetadata)this.$$_hibernate_getInterceptor().writeObject((Object)this, "metadata", (Object)this.metadata, (Object)jpaRoleMetadata);
            return;
        }
        this.metadata = jpaRoleMetadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)set);
            return;
        }
        this.attributes = set;
    }
}

