/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.role;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;
import org.keycloak.storage.SearchableModelField;

public class JpaRoleModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaRoleEntity, RoleModel, JpaRoleModelCriteriaBuilder> {
    public JpaRoleModelCriteriaBuilder() {
        super(JpaRoleModelCriteriaBuilder::new);
    }

    private JpaRoleModelCriteriaBuilder(BiFunction<CriteriaBuilder, Root<JpaRoleEntity>, Predicate> predicateFunc) {
        super(JpaRoleModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaRoleModelCriteriaBuilder compare(SearchableModelField<? super RoleModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField.equals((Object)RoleModel.SearchableFields.REALM_ID) || modelField.equals((Object)RoleModel.SearchableFields.CLIENT_ID) || modelField.equals((Object)RoleModel.SearchableFields.NAME)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaRoleModelCriteriaBuilder((cb, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NE: {
                if (modelField.equals((Object)RoleModel.SearchableFields.IS_CLIENT_ROLE)) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaRoleModelCriteriaBuilder((cb, root) -> (Boolean)value[0] != false ? cb.isNull((Expression)root.get("clientId")) : cb.isNotNull((Expression)root.get("clientId")));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField.equals((Object)RoleModel.SearchableFields.ID)) {
                    Collection<Object> collectionValues;
                    if (value == null || value.length == 0) {
                        throw new CriterionNotSupportedException(modelField, op);
                    }
                    if (value.length == 1) {
                        if (value[0] instanceof Object[]) {
                            collectionValues = Arrays.asList(value[0]);
                        } else if (value[0] instanceof Collection) {
                            collectionValues = (Collection)value[0];
                        } else if (value[0] instanceof Stream) {
                            try (Stream str = (Stream)value[0];){
                                collectionValues = str.collect(Collectors.toCollection(ArrayList::new));
                            }
                        } else {
                            collectionValues = Collections.singleton(value[0]);
                        }
                    } else {
                        collectionValues = new HashSet<Object>(Arrays.asList(value));
                    }
                    return new JpaRoleModelCriteriaBuilder((cb, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        for (Object id : collectionValues) {
                            try {
                                in.value((Object)StringKeyConvertor.UUIDKey.INSTANCE.fromString(Objects.toString(id, null)));
                            }
                            catch (IllegalArgumentException e) {
                                throw new CriterionNotSupportedException(modelField, op, id + " id is not in uuid format.", (Throwable)e);
                            }
                        }
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField.equals((Object)RoleModel.SearchableFields.NAME) || modelField.equals((Object)RoleModel.SearchableFields.DESCRIPTION)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaRoleModelCriteriaBuilder((cb, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

