/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RoleModel;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProvider;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.clientscope.JpaClientScopeMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.clientscope.entity.JpaClientScopeEntity;
import org.keycloak.models.map.storage.jpa.hibernate.listeners.JpaEntityVersionListener;
import org.keycloak.models.map.storage.jpa.hibernate.listeners.JpaOptimisticLockingListener;
import org.keycloak.models.map.storage.jpa.role.JpaRoleMapKeycloakTransaction;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class JpaMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "jpa-map-storage";
    private volatile EntityManagerFactory emf;
    private Config.Scope config;
    private static final Logger logger = Logger.getLogger(JpaMapStorageProviderFactory.class);
    public static final DeepCloner CLONER = new DeepCloner.Builder().constructor(JpaClientEntity.class, JpaClientEntity::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).constructor(JpaClientScopeEntity.class, JpaClientScopeEntity::new).constructor(JpaRoleEntity.class, JpaRoleEntity::new).build();
    private static final Map<Class<?>, Function<EntityManager, MapKeycloakTransaction>> MODEL_TO_TX = new HashMap();

    public MapKeycloakTransaction createTransaction(Class<?> modelType, EntityManager em) {
        return MODEL_TO_TX.get(modelType).apply(em);
    }

    public MapStorageProvider create(KeycloakSession session) {
        this.lazyInit();
        return new JpaMapStorageProvider(this, session, this.emf.createEntityManager());
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "JPA Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.emf == null) {
            JpaMapStorageProviderFactory jpaMapStorageProviderFactory = this;
            synchronized (jpaMapStorageProviderFactory) {
                if (this.emf == null) {
                    logger.debugf("Initializing JPA connections %s", StackUtil.getShortStackTrace());
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String unitName = this.config.get("persistenceUnitName", "keycloak-jpa-default");
                    String dataSource = this.config.get("dataSource");
                    if (dataSource != null) {
                        properties.put("javax.persistence.nonJtaDataSource", dataSource);
                    } else {
                        String password;
                        properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                        properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                        String user = this.config.get("user");
                        if (user != null) {
                            properties.put("javax.persistence.jdbc.user", user);
                        }
                        if ((password = this.config.get("password")) != null) {
                            properties.put("javax.persistence.jdbc.password", password);
                        }
                    }
                    String schema = this.config.get("schema");
                    if (schema != null) {
                        properties.put("hibernate.default_schema", schema);
                    }
                    properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                    properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                    properties.put("hibernate.dialect", this.config.get("driverDialect"));
                    properties.put("hibernate.integrator_provider", () -> Collections.singletonList(new Integrator(){

                        public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
                            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)sessionFactoryServiceRegistry.getService(EventListenerRegistry.class);
                            eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{JpaOptimisticLockingListener.INSTANCE});
                            eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{JpaOptimisticLockingListener.INSTANCE});
                            eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{JpaOptimisticLockingListener.INSTANCE});
                            eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{JpaEntityVersionListener.INSTANCE});
                            eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{JpaEntityVersionListener.INSTANCE});
                            eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{JpaEntityVersionListener.INSTANCE});
                        }

                        public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
                        }
                    }));
                    Integer isolation = this.config.getInt("isolation");
                    if (isolation != null) {
                        if (isolation < 4) {
                            logger.warn((Object)"Concurrent requests may not be reliable with transaction level lower than TRANSACTION_REPEATABLE_READ.");
                        }
                        properties.put("hibernate.connection.isolation", String.valueOf(isolation));
                    } else {
                        logger.warn((Object)"Concurrent requests may not be reliable with transaction level lower than TRANSACTION_REPEATABLE_READ.");
                    }
                    logger.trace((Object)"Creating EntityManagerFactory");
                    this.emf = Persistence.createEntityManagerFactory((String)unitName, properties);
                    logger.trace((Object)"EntityManagerFactory created");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdateSchema(KeycloakSession session, Class<?> modelType) {
        Connection connection = this.getConnection();
        try {
            MapJpaUpdaterProvider updater;
            MapJpaUpdaterProvider.Status status;
            if (logger.isDebugEnabled()) {
                this.printOperationalInfo(connection);
            }
            if (!(status = (updater = (MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class)).validate(modelType, connection, this.config.get("schema"))).equals((Object)MapJpaUpdaterProvider.Status.VALID)) {
                this.update(modelType, connection, session);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)"Can't close connection", (Throwable)e);
                }
            }
        }
    }

    private Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)this.config.get("url"), (Properties)System.getProperties()), this.config.get("user"), this.config.get("password"));
        }
        catch (ClassNotFoundException | SQLException | NamingException e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    private void printOperationalInfo(Connection connection) {
        try {
            LinkedHashMap<String, String> operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            operationalInfo.put("databaseUrl", md.getURL());
            operationalInfo.put("databaseUser", md.getUserName());
            operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private void update(Class<?> modelType, Connection connection, KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), lockSession -> {
            DBLockProvider dbLock = (DBLockProvider)session.getProvider(DBLockProvider.class);
            dbLock.waitForLock(DBLockProvider.Namespace.DATABASE);
            try {
                ((MapJpaUpdaterProvider)session.getProvider(MapJpaUpdaterProvider.class)).update(modelType, connection, this.config.get("schema"));
            }
            finally {
                dbLock.releaseLock();
            }
        });
    }

    static {
        MODEL_TO_TX.put(ClientScopeModel.class, JpaClientScopeMapKeycloakTransaction::new);
        MODEL_TO_TX.put(ClientModel.class, JpaClientMapKeycloakTransaction::new);
        MODEL_TO_TX.put(RoleModel.class, JpaRoleMapKeycloakTransaction::new);
    }
}

