/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import java.util.LinkedList;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.utils.StreamsUtil;

public abstract class JpaMapKeycloakTransaction<RE extends JpaRootEntity, E extends AbstractEntity, M>
extends JpaKeycloakTransaction
implements MapKeycloakTransaction<E, M> {
    private final Class<RE> entityType;

    public JpaMapKeycloakTransaction(Class<RE> entityType, EntityManager em) {
        super(em);
        this.entityType = entityType;
    }

    protected abstract Selection<? extends RE> selectCbConstruct(CriteriaBuilder var1, Root<RE> var2);

    protected abstract void setEntityVersion(JpaRootEntity var1);

    protected abstract JpaModelCriteriaBuilder createJpaModelCriteriaBuilder();

    protected abstract E mapToEntityDelegate(RE var1);

    public E create(E mapEntity) {
        JpaRootEntity jpaEntity = (JpaRootEntity)this.entityType.cast(JpaMapStorageProviderFactory.CLONER.from(mapEntity));
        JpaMapStorageProviderFactory.CLONER.from(mapEntity);
        if (mapEntity.getId() == null) {
            jpaEntity.setId(StringKeyConvertor.UUIDKey.INSTANCE.yieldNewUniqueKey().toString());
        }
        this.setEntityVersion(jpaEntity);
        this.em.persist((Object)jpaEntity);
        return (E)jpaEntity;
    }

    public E read(String key) {
        if (key == null) {
            return null;
        }
        UUID uuid = (UUID)StringKeyConvertor.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return null;
        }
        return (E)((AbstractEntity)this.em.find(this.entityType, (Object)uuid));
    }

    public Stream<E> read(QueryParameters<M> queryParameters) {
        BiFunction predicateFunc;
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.entityType);
        Root root = query.from(this.entityType);
        query.select(this.selectCbConstruct(cb, root));
        if (!queryParameters.getOrderBy().isEmpty()) {
            LinkedList<Order> orderByList = new LinkedList<Order>();
            block4: for (QueryParameters.OrderBy order : queryParameters.getOrderBy()) {
                switch (order.getOrder()) {
                    case ASCENDING: {
                        orderByList.add(cb.asc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                    case DESCENDING: {
                        orderByList.add(cb.desc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("Unknown ordering.");
            }
            query.orderBy(orderByList);
        }
        if ((predicateFunc = mcb.getPredicateFunc()) != null) {
            query.where((Expression)predicateFunc.apply(cb, root));
        }
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(query), (Integer)queryParameters.getOffset(), (Integer)queryParameters.getLimit()).getResultStream()).map(this::mapToEntityDelegate);
    }

    public long getCount(QueryParameters<M> queryParameters) {
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(this.entityType);
        countQuery.select((Selection)cb.count((Expression)root));
        BiFunction predicateFunc = mcb.getPredicateFunc();
        if (predicateFunc != null) {
            countQuery.where((Expression)predicateFunc.apply(cb, root));
        }
        return (Long)this.em.createQuery(countQuery).getSingleResult();
    }

    public boolean delete(String key) {
        if (key == null) {
            return false;
        }
        UUID uuid = (UUID)StringKeyConvertor.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return false;
        }
        this.em.remove(this.em.getReference(this.entityType, (Object)uuid));
        return true;
    }

    public long delete(QueryParameters<M> queryParameters) {
        JpaModelCriteriaBuilder mcb = (JpaModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createJpaModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete deleteQuery = cb.createCriteriaDelete(this.entityType);
        Root root = deleteQuery.from(this.entityType);
        BiFunction predicateFunc = mcb.getPredicateFunc();
        if (predicateFunc != null) {
            deleteQuery.where((Expression)predicateFunc.apply(cb, root));
        }
        return this.em.createQuery(deleteQuery).executeUpdate();
    }
}

