/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.updater;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.LiquibaseException;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.jpa.liquibase.connection.MapLiquibaseConnectionProvider;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;

public class MapJpaLiquibaseUpdaterProvider
implements MapJpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(MapJpaLiquibaseUpdaterProvider.class);
    private final KeycloakSession session;

    public MapJpaLiquibaseUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void update(Class modelType, Connection connection, String defaultSchema) {
        this.update(modelType, connection, null, defaultSchema);
    }

    @Override
    public void export(Class modelType, Connection connection, String defaultSchema, File file) {
        this.update(modelType, connection, file, defaultSchema);
    }

    private void update(Class modelType, Connection connection, File file, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        ThreadLocalSessionContext.setCurrentSession((KeycloakSession)this.session);
        Writer exportWriter = null;
        try {
            Liquibase liquibase = this.getLiquibase(modelType, connection, defaultSchema);
            if (file != null) {
                exportWriter = new FileWriter(file);
            }
            this.updateChangeSet(liquibase);
        }
        catch (IOException | SQLException | LiquibaseException e) {
            logger.error((Object)"Error has occurred while updating the database", e);
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            ThreadLocalSessionContext.removeCurrentSession();
            if (exportWriter != null) {
                try {
                    exportWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void updateChangeSet(Liquibase liquibase) throws LiquibaseException, SQLException {
        String changelog = liquibase.getChangeLogFile();
        List<ChangeSet> changeSets = this.getLiquibaseUnrunChangeSets(liquibase);
        if (!changeSets.isEmpty()) {
            List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
            if (ranChangeSets.isEmpty()) {
                logger.infov("Initializing database schema. Using changelog {0}", (Object)changelog);
            } else if (logger.isDebugEnabled()) {
                logger.debugv("Updating database from {0} to {1}. Using changelog {2}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)changeSets.get(changeSets.size() - 1).getId(), (Object)changelog);
            } else {
                logger.infov("Updating database. Using changelog {0}", (Object)changelog);
            }
            liquibase.update((Contexts)null);
            logger.debugv("Completed database update for changelog {0}", (Object)changelog);
        } else {
            logger.debugv("Database is up to date for changelog {0}", (Object)changelog);
        }
    }

    @Override
    public MapJpaUpdaterProvider.Status validate(Class modelType, Connection connection, String defaultSchema) {
        logger.debug((Object)"Validating if database is updated");
        ThreadLocalSessionContext.setCurrentSession((KeycloakSession)this.session);
        try {
            Liquibase liquibase = this.getLiquibase(modelType, connection, defaultSchema);
            MapJpaUpdaterProvider.Status status = this.validateChangeSet(liquibase, liquibase.getChangeLogFile());
            if (status != MapJpaUpdaterProvider.Status.VALID) {
                return status;
            }
        }
        catch (LiquibaseException e) {
            throw new RuntimeException("Failed to validate database", e);
        }
        return MapJpaUpdaterProvider.Status.VALID;
    }

    protected MapJpaUpdaterProvider.Status validateChangeSet(Liquibase liquibase, String changelog) throws LiquibaseException {
        MapJpaUpdaterProvider.Status result;
        List<ChangeSet> changeSets = this.getLiquibaseUnrunChangeSets(liquibase);
        if (!changeSets.isEmpty()) {
            if (changeSets.size() == liquibase.getDatabaseChangeLog().getChangeSets().size()) {
                result = MapJpaUpdaterProvider.Status.EMPTY;
            } else {
                logger.debugf("Validation failed. Database is not up-to-date for changelog %s", (Object)changelog);
                result = MapJpaUpdaterProvider.Status.OUTDATED;
            }
        } else {
            logger.debugf("Validation passed. Database is up-to-date for changelog %s", (Object)changelog);
            result = MapJpaUpdaterProvider.Status.VALID;
        }
        return result;
    }

    private List<ChangeSet> getLiquibaseUnrunChangeSets(Liquibase liquibase) throws LiquibaseException {
        return liquibase.listUnrunChangeSets(null, new LabelExpression(), false);
    }

    private Liquibase getLiquibase(Class modelType, Connection connection, String defaultSchema) throws LiquibaseException {
        MapLiquibaseConnectionProvider liquibaseProvider = (MapLiquibaseConnectionProvider)this.session.getProvider(MapLiquibaseConnectionProvider.class);
        String modelName = ModelEntityUtil.getModelName((Class)modelType);
        if (modelName == null) {
            throw new IllegalStateException("Cannot find changlelog for modelClass " + modelType.getName());
        }
        String changelog = "META-INF/jpa-" + modelName + "-changelog.xml";
        return liquibaseProvider.getLiquibaseForCustomUpdate(connection, defaultSchema, changelog, this.getClass().getClassLoader(), "databasechangelog");
    }

    public void close() {
    }

    public static String getTable(String table, String defaultSchema) {
        return defaultSchema != null ? defaultSchema + "." + table : table;
    }
}

