/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.jsonb;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JpaEntityMigration;

public class JsonbType
extends AbstractSingleColumnStandardBasicType<Object>
implements DynamicParameterizedType {
    public static final JsonbType INSTANCE = new JsonbType();
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).activateDefaultTyping((PolymorphicTypeValidator)new LaissezFaireSubTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, JsonTypeInfo.As.PROPERTY).registerModule((Module)new SimpleModule().addAbstractTypeMapping(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl.class)).addMixIn(UpdatableEntity.class, Serialization.IgnoreUpdatedMixIn.class).addMixIn(DeepCloner.class, Serialization.IgnoredTypeMixIn.class).addMixIn(EntityWithAttributes.class, IgnoredMetadataFieldsMixIn.class);

    public JsonbType() {
        super((SqlTypeDescriptor)JsonbSqlTypeDescriptor.INSTANCE, (JavaTypeDescriptor)new JsonbJavaTypeDescriptor());
    }

    public void setParameterValues(Properties parameters) {
        ((JsonbJavaTypeDescriptor)this.getJavaTypeDescriptor()).setParameterValues(parameters);
    }

    public String getName() {
        return "jsonb";
    }

    private static class JsonbJavaTypeDescriptor
    extends AbstractTypeDescriptor<Object>
    implements DynamicParameterizedType {
        private Class valueType;

        public void setParameterValues(Properties parameters) {
            this.valueType = ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
        }

        public JsonbJavaTypeDescriptor() {
            super(Object.class, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

                protected Object deepCopyNotNull(Object value) {
                    try {
                        return MAPPER.readValue(MAPPER.writerFor(value.getClass()).writeValueAsBytes(value), value.getClass());
                    }
                    catch (IOException e) {
                        throw new HibernateException("unable to deep copy object", (Throwable)e);
                    }
                }
            });
        }

        public Object fromString(String json) {
            try {
                ObjectNode tree = (ObjectNode)MAPPER.readValue(json, ObjectNode.class);
                JsonNode ev = tree.get("entityVersion");
                if (ev == null || !ev.isInt()) {
                    throw new IllegalArgumentException("unable to read entity version from " + json);
                }
                Integer entityVersion = ev.asInt();
                tree = this.migrate(tree, entityVersion);
                return MAPPER.treeToValue((TreeNode)tree, this.valueType);
            }
            catch (IOException e) {
                throw new HibernateException("unable to read", (Throwable)e);
            }
        }

        private ObjectNode migrate(ObjectNode tree, Integer entityVersion) {
            return JpaEntityMigration.MIGRATIONS.getOrDefault(this.valueType, (node, version) -> node).apply(tree, entityVersion);
        }

        public <X> X unwrap(Object value, Class<X> type, WrapperOptions options) {
            if (value == null) {
                return null;
            }
            String stringValue = value instanceof String ? (String)value : this.toString(value);
            try {
                return (X)MAPPER.readTree(stringValue);
            }
            catch (IOException e) {
                throw new HibernateException("unable to read", (Throwable)e);
            }
        }

        public <X> Object wrap(X value, WrapperOptions options) {
            if (value == null) {
                return null;
            }
            return this.fromString(value.toString());
        }

        public String toString(Object value) {
            try {
                return MAPPER.writeValueAsString(value);
            }
            catch (IOException e) {
                throw new HibernateException("unable to tranform value: " + value + " as String.", (Throwable)e);
            }
        }

        public boolean areEqual(Object one, Object another) {
            if (one == another) {
                return true;
            }
            if (one == null || another == null) {
                return Objects.equals(one, another);
            }
            try {
                return MAPPER.readTree(this.toString(one)).equals((Object)MAPPER.readTree(this.toString(another)));
            }
            catch (IOException e) {
                throw new HibernateException("unable to perform areEqual", (Throwable)e);
            }
        }
    }

    private static class JsonbSqlTypeDescriptor
    implements SqlTypeDescriptor {
        private static final JsonbSqlTypeDescriptor INSTANCE = new JsonbSqlTypeDescriptor();

        private JsonbSqlTypeDescriptor() {
        }

        public int getSqlType() {
            return 1111;
        }

        public boolean canBeRemapped() {
            return true;
        }

        public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setObject(index, javaTypeDescriptor.unwrap(value, JsonNode.class, options), this.getSqlType());
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setObject(name, javaTypeDescriptor.unwrap(value, JsonNode.class, options), this.getSqlType());
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(this.extractJson(rs, name), options);
                }

                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(this.extractJson(statement, index), options);
                }

                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(this.extractJson(statement, name), options);
                }
            };
        }

        private Object extractJson(ResultSet rs, String name) throws SQLException {
            return rs.getObject(name);
        }

        private Object extractJson(CallableStatement statement, int index) throws SQLException {
            return statement.getObject(index);
        }

        private Object extractJson(CallableStatement statement, String name) throws SQLException {
            return statement.getObject(name);
        }
    }

    abstract class IgnoredMetadataFieldsMixIn {
        IgnoredMetadataFieldsMixIn() {
        }

        @JsonIgnore
        public abstract String getId();

        @JsonIgnore
        public abstract Map<String, List<String>> getAttributes();

        @JsonIgnore
        public abstract Boolean isClientRole();
    }
}

