/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public abstract class JpaModelCriteriaBuilder<E, M, Self extends JpaModelCriteriaBuilder<E, M, Self>>
implements ModelCriteriaBuilder<M, Self> {
    private final Function<BiFunction<CriteriaBuilder, Root<E>, Predicate>, Self> instantiator;
    private BiFunction<CriteriaBuilder, Root<E>, Predicate> predicateFunc = null;

    public JpaModelCriteriaBuilder(Function<BiFunction<CriteriaBuilder, Root<E>, Predicate>, Self> instantiator) {
        this.instantiator = instantiator;
    }

    public JpaModelCriteriaBuilder(Function<BiFunction<CriteriaBuilder, Root<E>, Predicate>, Self> instantiator, BiFunction<CriteriaBuilder, Root<E>, Predicate> predicateFunc) {
        this.instantiator = instantiator;
        this.predicateFunc = predicateFunc;
    }

    protected void validateValue(Object[] value, SearchableModelField<? super M> field, ModelCriteriaBuilder.Operator op, Class<?> ... expectedTypes) {
        if (value == null || expectedTypes == null || value.length != expectedTypes.length) {
            throw new CriterionNotSupportedException(field, op, "Invalid argument: " + Arrays.toString(value));
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (expectedTypes[i].isInstance(value[i])) continue;
            throw new CriterionNotSupportedException(field, op, "Expected types: " + Arrays.toString(expectedTypes) + " but got: " + Arrays.toString(value));
        }
    }

    protected String convertToJson(Object input) {
        try {
            return JsonbType.MAPPER.writeValueAsString(input);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Unable to write value as String.", ex);
        }
    }

    @SafeVarargs
    public final Self and(Self ... builders) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, root) -> cb.and((Predicate[])Stream.of(builders).map(b -> b.getPredicateFunc().apply((CriteriaBuilder)cb, (Root)root)).toArray(Predicate[]::new))));
    }

    @SafeVarargs
    public final Self or(Self ... builders) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, root) -> cb.or((Predicate[])Stream.of(builders).map(b -> b.getPredicateFunc().apply((CriteriaBuilder)cb, (Root)root)).toArray(Predicate[]::new))));
    }

    public Self not(Self builder) {
        return (Self)((JpaModelCriteriaBuilder)this.instantiator.apply((cb, root) -> cb.not((Expression)builder.getPredicateFunc().apply((CriteriaBuilder)cb, (Root)root))));
    }

    public BiFunction<CriteriaBuilder, Root<E>, Predicate> getPredicateFunc() {
        return this.predicateFunc;
    }
}

