/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authSession;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.sessions.CommonClientSessionModel;

public class HotRodAuthenticationSessionEntity
extends AbstractHotRodEntity {
    @ProtoField(number=1)
    public String tabId;
    @ProtoField(number=2)
    public String clientUUID;
    @ProtoField(number=3)
    public String authUserId;
    @ProtoField(number=4)
    public Long timestamp;
    @ProtoField(number=5)
    public String redirectUri;
    @ProtoField(number=6)
    public String action;
    @ProtoField(number=7)
    public Set<String> clientScopes;
    @ProtoField(number=8)
    public Set<HotRodPair<String, Integer>> executionStatuses;
    @ProtoField(number=9)
    public String protocol;
    @ProtoField(number=10)
    public Set<HotRodPair<String, String>> clientNotes;
    @ProtoField(number=11)
    public Set<HotRodPair<String, String>> authNotes;
    @ProtoField(number=12)
    public Set<String> requiredActions;
    @ProtoField(number=13)
    public Set<HotRodPair<String, String>> userSessionNotes;

    public boolean equals(Object o) {
        return HotRodAuthenticationSessionEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodAuthenticationSessionEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodAuthenticationSessionEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodAuthenticationSessionEntity>
    implements MapAuthenticationSessionEntity {
        public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatuses() {
            Set<HotRodPair<String, Integer>> executionStatuses = ((HotRodAuthenticationSessionEntity)this.getHotRodEntity()).executionStatuses;
            if (executionStatuses == null) {
                return Collections.emptyMap();
            }
            return executionStatuses.stream().collect(Collectors.toMap(HotRodPair::getKey, v -> CommonClientSessionModel.ExecutionStatus.valueOfInteger((Integer)((Integer)v.getValue()))));
        }

        public void setExecutionStatuses(Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus) {
            HotRodAuthenticationSessionEntity hotRodEntity = (HotRodAuthenticationSessionEntity)this.getHotRodEntity();
            Set executionStatusSet = executionStatus == null ? null : executionStatus.entrySet().stream().map(e -> new HotRodPair<String, Integer>((String)e.getKey(), ((CommonClientSessionModel.ExecutionStatus)e.getValue()).getStableIndex())).collect(Collectors.toSet());
            hotRodEntity.updated = hotRodEntity.updated | !Objects.equals(hotRodEntity.executionStatuses, executionStatusSet);
            hotRodEntity.executionStatuses = executionStatusSet;
        }

        public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
            HotRodAuthenticationSessionEntity hotRodEntity = (HotRodAuthenticationSessionEntity)this.getHotRodEntity();
            if (hotRodEntity.executionStatuses == null) {
                hotRodEntity.executionStatuses = new HashSet<HotRodPair<String, Integer>>();
            }
            boolean valueUndefined = status == null;
            hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(hotRodEntity.executionStatuses, authenticator, HotRodTypesUtils::getKey);
            hotRodEntity.updated = hotRodEntity.updated | (!valueUndefined && hotRodEntity.executionStatuses.add(new HotRodPair<String, Integer>(authenticator, status.getStableIndex())));
        }
    }
}

