/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.common;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;

public class HotRodTypesUtils {
    public static <MapKey, MapValue, SetValue> Set<SetValue> migrateMapToSet(Map<MapKey, MapValue> map, Function<Map.Entry<MapKey, MapValue>, SetValue> creator) {
        return map == null ? null : map.entrySet().stream().map(creator).collect(Collectors.toSet());
    }

    public static <MapKey, MapValue, SetValue> Map<MapKey, MapValue> migrateSetToMap(Set<SetValue> set, Function<SetValue, MapKey> keyProducer, Function<SetValue, MapValue> valueProducer) {
        return set == null ? null : set.stream().collect(Collectors.toMap(keyProducer, valueProducer));
    }

    public static <T, V> HotRodPair<T, V> createHotRodPairFromMapEntry(Map.Entry<T, V> entry) {
        return new HotRodPair<T, V>(entry.getKey(), entry.getValue());
    }

    public static HotRodAttributeEntity createHotRodAttributeEntityFromMapEntry(Map.Entry<String, List<String>> entry) {
        return new HotRodAttributeEntity(entry.getKey(), entry.getValue());
    }

    public static HotRodAttributeEntityNonIndexed createHotRodAttributeEntityNonIndexedFromMapEntry(Map.Entry<String, List<String>> entry) {
        return new HotRodAttributeEntityNonIndexed(entry.getKey(), entry.getValue());
    }

    public static <SetType, KeyType> boolean removeFromSetByMapKey(Set<SetType> set, KeyType key, Function<SetType, KeyType> keyGetter) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.stream().filter(entry -> Objects.equals(keyGetter.apply(entry), key)).findFirst().map(set::remove).orElse(false);
    }

    public static <SetType, MapKey, MapValue> MapValue getMapValueFromSet(Set<SetType> set, MapKey key, Function<SetType, MapKey> keyGetter, Function<SetType, MapValue> valueGetter) {
        return set == null ? null : set.stream().filter(entry -> Objects.equals(keyGetter.apply(entry), key)).findFirst().map(valueGetter).orElse(null);
    }

    public static <K, V> K getKey(HotRodPair<K, V> hotRodPair) {
        return hotRodPair.getKey();
    }

    public static <K, V> V getValue(HotRodPair<K, V> hotRodPair) {
        return hotRodPair.getValue();
    }

    public static String getKey(HotRodAttributeEntity attributeEntity) {
        return attributeEntity.name;
    }

    public static String getKey(HotRodAttributeEntityNonIndexed attributeEntity) {
        return attributeEntity.name;
    }

    public static List<String> getValue(HotRodAttributeEntity attributeEntity) {
        return attributeEntity.values;
    }

    public static List<String> getValue(HotRodAttributeEntityNonIndexed attributeEntity) {
        return attributeEntity.values;
    }

    public static String getKey(AbstractEntity entity) {
        return entity.getId();
    }
}

