/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.ClientModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryOperators;
import org.keycloak.storage.SearchableModelField;

public class IckleQueryWhereClauses {
    private static final Map<SearchableModelField<?>, WhereClauseProducer> WHERE_CLAUSE_PRODUCER_OVERRIDES = new HashMap();

    private static String produceWhereClause(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        return IckleQueryOperators.combineExpressions(op, modelFieldName, values, parameters);
    }

    private static WhereClauseProducer whereClauseProducerForModelField(SearchableModelField<?> modelField) {
        return WHERE_CLAUSE_PRODUCER_OVERRIDES.getOrDefault(modelField, IckleQueryWhereClauses::produceWhereClause);
    }

    public static String produceWhereClause(SearchableModelField<?> modelField, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        String fieldName = IckleQueryMapModelCriteriaBuilder.getFieldName(modelField);
        if (IckleQueryMapModelCriteriaBuilder.isAnalyzedModelField(modelField) && (op.equals((Object)ModelCriteriaBuilder.Operator.ILIKE) || op.equals((Object)ModelCriteriaBuilder.Operator.EQ) || op.equals((Object)ModelCriteriaBuilder.Operator.NE))) {
            String clause = "c." + fieldName + " : '" + IckleQueryMapModelCriteriaBuilder.sanitizeAnalyzed(values[0]) + "'";
            if (op.equals((Object)ModelCriteriaBuilder.Operator.NE)) {
                return "not(" + clause + ")";
            }
            return clause;
        }
        return IckleQueryWhereClauses.whereClauseProducerForModelField(modelField).produceWhereClause(fieldName, op, values, parameters);
    }

    private static String whereClauseForClientsAttributes(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        if (values == null || values.length != 2) {
            throw new CriterionNotSupportedException(ClientModel.SearchableFields.ATTRIBUTE, op, "Invalid arguments, expected attribute_name-value pair, got: " + Arrays.toString(values));
        }
        Object attrName = values[0];
        if (!(attrName instanceof String)) {
            throw new CriterionNotSupportedException(ClientModel.SearchableFields.ATTRIBUTE, op, "Invalid arguments, expected (String attribute_name), got: " + Arrays.toString(values));
        }
        String attrNameS = (String)attrName;
        Object[] realValues = new Object[values.length - 1];
        System.arraycopy(values, 1, realValues, 0, values.length - 1);
        String nameClause = IckleQueryOperators.combineExpressions(ModelCriteriaBuilder.Operator.EQ, modelFieldName + ".name", new Object[]{attrNameS}, parameters);
        String valueClause = IckleQueryOperators.combineExpressions(op, modelFieldName + ".values", realValues, parameters);
        return "(" + nameClause + ") AND (" + valueClause + ")";
    }

    static {
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(ClientModel.SearchableFields.ATTRIBUTE, IckleQueryWhereClauses::whereClauseForClientsAttributes);
    }

    @FunctionalInterface
    private static interface WhereClauseProducer {
        public String produceWhereClause(String var1, ModelCriteriaBuilder.Operator var2, Object[] var3, Map<String, Object> var4);
    }
}

