/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryOperators;
import org.keycloak.models.map.storage.hotRod.IckleQueryWhereClauses;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.storage.SearchableModelField;

public class IckleQueryMapModelCriteriaBuilder<E extends AbstractHotRodEntity, M>
implements ModelCriteriaBuilder<M, IckleQueryMapModelCriteriaBuilder<E, M>> {
    private static final int INITIAL_BUILDER_CAPACITY = 250;
    private final Class<E> hotRodEntityClass;
    private final StringBuilder whereClauseBuilder = new StringBuilder(250);
    private final Map<String, Object> parameters;
    private static final String NON_ANALYZED_FIELD_REGEX = "[%_\\\\]";
    private static final String ANALYZED_FIELD_REGEX = "[+!^\"~*?:\\\\]";
    public static final Map<SearchableModelField<?>, String> INFINISPAN_NAME_OVERRIDES = new HashMap();
    public static final Set<SearchableModelField<?>> ANALYZED_MODEL_FIELDS = new HashSet();

    public IckleQueryMapModelCriteriaBuilder(Class<E> hotRodEntityClass, StringBuilder whereClauseBuilder, Map<String, Object> parameters) {
        this.hotRodEntityClass = hotRodEntityClass;
        this.whereClauseBuilder.append((CharSequence)whereClauseBuilder);
        this.parameters = parameters;
    }

    public IckleQueryMapModelCriteriaBuilder(Class<E> hotRodEntityClass) {
        this.hotRodEntityClass = hotRodEntityClass;
        this.parameters = new HashMap<String, Object>();
    }

    public static String getFieldName(SearchableModelField<?> modelField) {
        return INFINISPAN_NAME_OVERRIDES.getOrDefault(modelField, modelField.getName());
    }

    private static boolean notEmpty(StringBuilder builder) {
        return builder.length() != 0;
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> compare(SearchableModelField<? super M> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        StringBuilder newBuilder = new StringBuilder(250);
        newBuilder.append("(");
        if (IckleQueryMapModelCriteriaBuilder.notEmpty(this.whereClauseBuilder)) {
            newBuilder.append((CharSequence)this.whereClauseBuilder).append(" AND (");
        }
        HashMap<String, Object> newParameters = new HashMap<String, Object>(this.parameters);
        newBuilder.append(IckleQueryWhereClauses.produceWhereClause(modelField, op, value, newParameters));
        if (IckleQueryMapModelCriteriaBuilder.notEmpty(this.whereClauseBuilder)) {
            newBuilder.append(")");
        }
        return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass, newBuilder.append(")"), newParameters);
    }

    private StringBuilder joinBuilders(IckleQueryMapModelCriteriaBuilder<E, M>[] builders, String delimiter) {
        return new StringBuilder(250).append("(").append(Arrays.stream(builders).map(IckleQueryMapModelCriteriaBuilder::getWhereClauseBuilder).filter(IckleQueryMapModelCriteriaBuilder::notEmpty).collect(Collectors.joining(delimiter))).append(")");
    }

    private Map<String, Object> joinParameters(IckleQueryMapModelCriteriaBuilder<E, M>[] builders) {
        return Arrays.stream(builders).map(IckleQueryMapModelCriteriaBuilder::getParameters).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private IckleQueryMapModelCriteriaBuilder<E, M>[] resolveNamedQueryConflicts(IckleQueryMapModelCriteriaBuilder<E, M>[] builders) {
        HashSet existingKeys = new HashSet();
        return (IckleQueryMapModelCriteriaBuilder[])Arrays.stream(builders).map(builder -> {
            Map<String, Object> oldParameters = builder.getParameters();
            if (oldParameters.keySet().stream().noneMatch(existingKeys::contains)) {
                existingKeys.addAll(oldParameters.keySet());
                return builder;
            }
            String newWhereClause = builder.getWhereClauseBuilder().toString();
            HashMap<String, Object> newParameters = new HashMap<String, Object>();
            for (String key : oldParameters.keySet()) {
                if (existingKeys.contains(key)) {
                    String newNamedParameter = IckleQueryOperators.findAvailableNamedParam(existingKeys, key + "n");
                    newParameters.put(newNamedParameter, oldParameters.get(key));
                    newWhereClause = newWhereClause.replace(key, newNamedParameter);
                    existingKeys.add(newNamedParameter);
                    continue;
                }
                newParameters.put(key, oldParameters.get(key));
                existingKeys.add(key);
            }
            return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass, new StringBuilder(newWhereClause), newParameters);
        }).toArray(IckleQueryMapModelCriteriaBuilder[]::new);
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> and(IckleQueryMapModelCriteriaBuilder<E, M> ... builders) {
        if (builders.length == 0) {
            return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass);
        }
        builders = this.resolveNamedQueryConflicts(builders);
        return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass, this.joinBuilders(builders, " AND "), this.joinParameters(builders));
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> or(IckleQueryMapModelCriteriaBuilder<E, M> ... builders) {
        if (builders.length == 0) {
            return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass);
        }
        builders = this.resolveNamedQueryConflicts(builders);
        return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass, this.joinBuilders(builders, " OR "), this.joinParameters(builders));
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> not(IckleQueryMapModelCriteriaBuilder<E, M> builder) {
        StringBuilder newBuilder = new StringBuilder(250);
        StringBuilder originalBuilder = super.getWhereClauseBuilder();
        if (originalBuilder.length() != 0) {
            newBuilder.append("not").append((CharSequence)originalBuilder);
        }
        return new IckleQueryMapModelCriteriaBuilder<E, M>(this.hotRodEntityClass, newBuilder, builder.getParameters());
    }

    private StringBuilder getWhereClauseBuilder() {
        return this.whereClauseBuilder;
    }

    public static Object sanitize(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            boolean anyBeginning = sValue.startsWith("%");
            boolean anyEnd = sValue.endsWith("%");
            String sanitizedString = sValue.substring(anyBeginning ? 1 : 0, sValue.length() - (anyEnd ? 1 : 0)).replaceAll(NON_ANALYZED_FIELD_REGEX, "\\\\\\\\$0");
            return (anyBeginning ? "%" : "") + sanitizedString + (anyEnd ? "%" : "");
        }
        return value;
    }

    public static Object sanitizeAnalyzed(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            boolean anyBeginning = sValue.startsWith("%");
            boolean anyEnd = sValue.endsWith("%");
            String sanitizedString = sValue.substring(anyBeginning ? 1 : 0, sValue.length() - (anyEnd ? 1 : 0)).replaceAll("\\\\", "\\\\\\\\");
            return (anyBeginning ? "*" : "") + sanitizedString + (anyEnd ? "*" : "");
        }
        return value;
    }

    public static boolean isAnalyzedModelField(SearchableModelField<?> modelField) {
        return ANALYZED_MODEL_FIELDS.contains(modelField);
    }

    public String getIckleQuery() {
        return "FROM kc." + this.hotRodEntityClass.getSimpleName() + " " + "c" + (this.whereClauseBuilder.length() != 0 ? " WHERE " + this.whereClauseBuilder : "");
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    static {
        INFINISPAN_NAME_OVERRIDES.put(ClientModel.SearchableFields.SCOPE_MAPPING_ROLE, "scopeMappings");
        INFINISPAN_NAME_OVERRIDES.put(ClientModel.SearchableFields.ATTRIBUTE, "attributes");
        INFINISPAN_NAME_OVERRIDES.put(GroupModel.SearchableFields.PARENT_ID, "parentId");
        INFINISPAN_NAME_OVERRIDES.put(GroupModel.SearchableFields.ASSIGNED_ROLE, "grantedRoles");
        ANALYZED_MODEL_FIELDS.add(RoleModel.SearchableFields.DESCRIPTION);
        ANALYZED_MODEL_FIELDS.add(UserModel.SearchableFields.FIRST_NAME);
        ANALYZED_MODEL_FIELDS.add(UserModel.SearchableFields.LAST_NAME);
        ANALYZED_MODEL_FIELDS.add(UserModel.SearchableFields.EMAIL);
    }
}

