/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.hotRod.HotRodMapStorageProvider;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntityDelegate;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.group.HotRodGroupEntity;
import org.keycloak.models.map.storage.hotRod.group.HotRodGroupEntityDelegate;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class HotRodMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "hotrod";
    private static final Logger LOG = Logger.getLogger(HotRodMapStorageProviderFactory.class);
    private static final DeepCloner CLONER = new DeepCloner.Builder().constructor(MapClientEntity.class, HotRodClientEntityDelegate::new).constructor(MapProtocolMapperEntity.class, HotRodProtocolMapperEntityDelegate::new).constructor(MapGroupEntity.class, HotRodGroupEntityDelegate::new).build();
    public static final Map<Class<?>, HotRodEntityDescriptor<?, ?>> ENTITY_DESCRIPTOR_MAP = new HashMap();

    public MapStorageProvider create(KeycloakSession session) {
        HotRodConnectionProvider cacheProvider = (HotRodConnectionProvider)session.getProvider(HotRodConnectionProvider.class);
        if (cacheProvider == null) {
            throw new IllegalStateException("Cannot find HotRodConnectionProvider interface implementation");
        }
        return new HotRodMapStorageProvider(this, cacheProvider, CLONER);
    }

    public HotRodEntityDescriptor<?, ?> getEntityDescriptor(Class<?> c) {
        return ENTITY_DESCRIPTOR_MAP.get(c);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public String getHelpText() {
        return "HotRod map storage";
    }

    static {
        ENTITY_DESCRIPTOR_MAP.put(ClientModel.class, new HotRodEntityDescriptor<HotRodClientEntity, HotRodClientEntityDelegate>(ClientModel.class, HotRodClientEntity.class, HotRodClientEntityDelegate::new));
        ENTITY_DESCRIPTOR_MAP.put(GroupModel.class, new HotRodEntityDescriptor<HotRodGroupEntity, HotRodGroupEntityDelegate>(GroupModel.class, HotRodGroupEntity.class, HotRodGroupEntityDelegate::new));
    }
}

