/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.common.HotRodUtils;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class HotRodMapStorage<K, E extends AbstractHotRodEntity, V extends HotRodEntityDelegate<E>, M>
implements MapStorage<V, M>,
ConcurrentHashMapCrudOperations<V, M> {
    private static final Logger LOG = Logger.getLogger(HotRodMapStorage.class);
    private final RemoteCache<K, E> remoteCache;
    private final StringKeyConvertor<K> keyConvertor;
    private final HotRodEntityDescriptor<E, V> storedEntityDescriptor;
    private final Function<E, V> delegateProducer;
    private final DeepCloner cloner;

    public HotRodMapStorage(RemoteCache<K, E> remoteCache, StringKeyConvertor<K> keyConvertor, HotRodEntityDescriptor<E, V> storedEntityDescriptor, DeepCloner cloner) {
        this.remoteCache = remoteCache;
        this.keyConvertor = keyConvertor;
        this.storedEntityDescriptor = storedEntityDescriptor;
        this.cloner = cloner;
        this.delegateProducer = storedEntityDescriptor.getHotRodDelegateProvider();
    }

    public V create(V value) {
        Object key = this.keyConvertor.fromStringSafe(value.getId());
        if (key == null) {
            key = this.keyConvertor.yieldNewUniqueKey();
            value = (HotRodEntityDelegate)this.cloner.from(this.keyConvertor.keyToString(key), value);
        }
        this.remoteCache.putIfAbsent(key, (Object)((AbstractHotRodEntity)value.getHotRodEntity()));
        return value;
    }

    public V read(String key) {
        Objects.requireNonNull(key, "Key must be non-null");
        Object k = this.keyConvertor.fromStringSafe(key);
        return (V)((HotRodEntityDelegate)this.delegateProducer.apply((AbstractHotRodEntity)this.remoteCache.get(k)));
    }

    public V update(V value) {
        Object key = this.keyConvertor.fromStringSafe(value.getId());
        return (V)((HotRodEntityDelegate)this.delegateProducer.apply((AbstractHotRodEntity)this.remoteCache.replace(key, (Object)((AbstractHotRodEntity)value.getHotRodEntity()))));
    }

    public boolean delete(String key) {
        Object k = this.keyConvertor.fromStringSafe(key);
        return this.remoteCache.remove(k) != null;
    }

    private static String toOrderString(QueryParameters.OrderBy<?> orderBy) {
        SearchableModelField field = orderBy.getModelField();
        String modelFieldName = IckleQueryMapModelCriteriaBuilder.getFieldName(field);
        String orderString = orderBy.getOrder().equals((Object)QueryParameters.Order.ASCENDING) ? "ASC" : "DESC";
        return modelFieldName + " " + orderString;
    }

    public Stream<V> read(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = iqmcb.getIckleQuery();
        if (!queryParameters.getOrderBy().isEmpty()) {
            queryString = queryString + " ORDER BY " + queryParameters.getOrderBy().stream().map(HotRodMapStorage::toOrderString).collect(Collectors.joining(", "));
        }
        LOG.tracef("Executing read Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = HotRodUtils.paginateQuery(queryFactory.create(queryString), queryParameters.getOffset(), queryParameters.getLimit());
        query.setParameters(iqmcb.getParameters());
        CloseableIterator iterator = query.iterator();
        return ((Stream)StreamsUtil.closing(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false)).onClose(() -> ((CloseableIterator)iterator).close())).filter(Objects::nonNull).map(this.delegateProducer);
    }

    public long getCount(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = iqmcb.getIckleQuery();
        LOG.tracef("Executing count Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = queryFactory.create(queryString);
        query.setParameters(iqmcb.getParameters());
        return query.execute().hitCount().orElse(0L);
    }

    public long delete(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = "SELECT id " + iqmcb.getIckleQuery();
        if (!queryParameters.getOrderBy().isEmpty()) {
            queryString = queryString + " ORDER BY " + queryParameters.getOrderBy().stream().map(HotRodMapStorage::toOrderString).collect(Collectors.joining(", "));
        }
        LOG.tracef("Executing delete Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = HotRodUtils.paginateQuery(queryFactory.create(queryString), queryParameters.getOffset(), queryParameters.getLimit());
        query.setParameters(iqmcb.getParameters());
        AtomicLong result = new AtomicLong();
        CloseableIterator iterator = query.iterator();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).peek(e -> result.incrementAndGet()).map(AbstractEntity::getId).forEach(this::delete);
        iterator.close();
        return result.get();
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> createCriteriaBuilder() {
        return new IckleQueryMapModelCriteriaBuilder(this.storedEntityDescriptor.getEntityTypeClass());
    }

    public MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session) {
        Map fieldPredicates = MapFieldPredicates.getPredicates(this.storedEntityDescriptor.getModelTypeClass());
        return new ConcurrentHashMapKeycloakTransaction((ConcurrentHashMapCrudOperations)this, this.keyConvertor, this.cloner, fieldPredicates);
    }
}

