/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.client;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntityDelegate;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;

public class HotRodClientEntity
implements AbstractHotRodEntity {
    @ProtoField(number=1, required=true)
    public int entityVersion = 1;
    @ProtoField(number=2, required=true)
    public String id;
    @ProtoField(number=3)
    public String realmId;
    @ProtoField(number=4)
    public String clientId;
    @ProtoField(number=5)
    public String name;
    @ProtoField(number=6)
    public String description;
    @ProtoField(number=7)
    public Set<String> redirectUris;
    @ProtoField(number=8)
    public Boolean enabled;
    @ProtoField(number=9)
    public Boolean alwaysDisplayInConsole;
    @ProtoField(number=10)
    public String clientAuthenticatorType;
    @ProtoField(number=11)
    public String secret;
    @ProtoField(number=12)
    public String registrationToken;
    @ProtoField(number=13)
    public String protocol;
    @ProtoField(number=14)
    public Set<HotRodAttributeEntity> attributes;
    @ProtoField(number=15)
    public Set<HotRodPair<String, String>> authenticationFlowBindingOverrides;
    @ProtoField(number=16)
    public Boolean publicClient;
    @ProtoField(number=17)
    public Boolean fullScopeAllowed;
    @ProtoField(number=18)
    public Boolean frontchannelLogout;
    @ProtoField(number=19)
    public Integer notBefore;
    @ProtoField(number=20)
    public Set<String> scope;
    @ProtoField(number=21)
    public Set<String> webOrigins;
    @ProtoField(number=22)
    public Set<HotRodProtocolMapperEntity> protocolMappers;
    @ProtoField(number=23)
    public Set<HotRodPair<String, Boolean>> clientScopes;
    @ProtoField(number=24, collectionImplementation=LinkedList.class)
    public Collection<String> scopeMappings;
    @ProtoField(number=25)
    public Boolean surrogateAuthRequired;
    @ProtoField(number=26)
    public String managementUrl;
    @ProtoField(number=27)
    public String baseUrl;
    @ProtoField(number=28)
    public Boolean bearerOnly;
    @ProtoField(number=29)
    public Boolean consentRequired;
    @ProtoField(number=30)
    public String rootUrl;
    @ProtoField(number=31)
    public Boolean standardFlowEnabled;
    @ProtoField(number=32)
    public Boolean implicitFlowEnabled;
    @ProtoField(number=33)
    public Boolean directAccessGrantsEnabled;
    @ProtoField(number=34)
    public Boolean serviceAccountsEnabled;
    @ProtoField(number=35)
    public Integer nodeReRegistrationTimeout;

    public boolean equals(Object o) {
        return HotRodClientEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodClientEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodClientEntityDelegate
    extends UpdatableEntity.Impl
    implements HotRodEntityDelegate<HotRodClientEntity>,
    MapClientEntity {
        public String getId() {
            return ((HotRodClientEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            this.updated |= id != null;
        }

        public Stream<String> getClientScopes(boolean defaultScope) {
            Map clientScopes = this.getClientScopes();
            return clientScopes == null ? Stream.empty() : clientScopes.entrySet().stream().filter(me -> Objects.equals(me.getValue(), defaultScope)).map(Map.Entry::getKey);
        }
    }
}

