/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.datastore;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.services.scheduled.ClearExpiredAdminEvents;
import org.keycloak.services.scheduled.ClearExpiredClientInitialAccessTokens;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.DatastoreProviderFactory;
import org.keycloak.storage.LegacyStoreMigrateRepresentationEvent;
import org.keycloak.storage.LegacyStoreSyncEvent;
import org.keycloak.storage.datastore.LegacyDatastoreProvider;
import org.keycloak.storage.managers.UserStorageSyncManager;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;

public class LegacyDatastoreProviderFactory
implements DatastoreProviderFactory,
ProviderEventListener,
EnvironmentDependentProviderFactory {
    private static final String PROVIDER_ID = "legacy";
    private long clientStorageProviderTimeout;
    private long roleStorageProviderTimeout;
    private Runnable onClose;

    public DatastoreProvider create(KeycloakSession session) {
        return new LegacyDatastoreProvider(this, session);
    }

    public void init(Config.Scope config) {
        this.clientStorageProviderTimeout = Config.scope((String[])new String[]{"client"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
        this.roleStorageProviderTimeout = Config.scope((String[])new String[]{"role"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public void close() {
        this.onClose.run();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public long getClientStorageProviderTimeout() {
        return this.clientStorageProviderTimeout;
    }

    public long getRoleStorageProviderTimeout() {
        return this.roleStorageProviderTimeout;
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            LegacyDatastoreProviderFactory.setupScheduledTasks(((PostMigrationEvent)event).getFactory());
        } else if (event instanceof LegacyStoreSyncEvent) {
            LegacyStoreSyncEvent ev = (LegacyStoreSyncEvent)event;
            UserStorageSyncManager.notifyToRefreshPeriodicSyncAll(ev.getSession(), ev.getRealm(), ev.getRemoved());
        } else if (event instanceof LegacyStoreMigrateRepresentationEvent) {
            LegacyStoreMigrateRepresentationEvent ev = (LegacyStoreMigrateRepresentationEvent)event;
            MigrationModelManager.migrateImport(ev.getSession(), ev.getRealm(), ev.getRep(), ev.isSkipUserDependent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(900L)) * 1000L;
        try (KeycloakSession session = sessionFactory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            if (timer != null) {
                timer.schedule((Runnable)((Object)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredEvents(), interval)), interval, "ClearExpiredEvents");
                timer.schedule((Runnable)((Object)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredAdminEvents(), interval)), interval, "ClearExpiredAdminEvents");
                timer.schedule((Runnable)((Object)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredClientInitialAccessTokens(), interval)), interval, "ClearExpiredClientInitialAccessTokens");
                timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, (ScheduledTask)new ClearExpiredUserSessions()), interval, "ClearExpiredUserSessions");
                UserStorageSyncManager.bootstrapPeriodic(sessionFactory, timer);
            }
        }
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

