/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.entities.UserEntity;
import org.keycloak.models.file.adapter.RealmAdapter;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.util.Time;

public class UserAdapter
implements UserModel,
Comparable {
    private final InMemoryModel inMemoryModel;
    private final UserEntity user;
    private final RealmModel realm;
    private final Set<RoleModel> allRoles = new HashSet<RoleModel>();

    public UserAdapter(RealmModel realm, UserEntity userEntity, InMemoryModel inMemoryModel) {
        this.user = userEntity;
        this.realm = realm;
        if (userEntity.getFederatedIdentities() == null) {
            userEntity.setFederatedIdentities(new ArrayList());
        }
        this.inMemoryModel = inMemoryModel;
    }

    public UserEntity getUserEntity() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        if (this.getUsername() == null) {
            this.user.setUsername(username);
            return;
        }
        if (this.getUsername().equals(username)) {
            return;
        }
        if (this.inMemoryModel.hasUserWithUsername(this.realm.getId(), username)) {
            throw new ModelDuplicateException("User with username " + username + " already exists in realm.");
        }
        this.user.setUsername(username);
    }

    public Long getCreatedTimestamp() {
        return this.user.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.user.setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        if ((email = KeycloakModelUtils.toLowerCaseSafe((String)email)) == null) {
            this.user.setEmail(email);
            return;
        }
        if (email.equals(this.getEmail())) {
            return;
        }
        RealmAdapter realmAdapter = (RealmAdapter)this.realm;
        if (realmAdapter.hasUserWithEmail(email)) {
            throw new ModelDuplicateException("User with email address " + email + " already exists.");
        }
        this.user.setEmail(email);
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    public void setSingleAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add(value);
        this.user.getAttributes().put(name, attrValues);
    }

    public void setAttribute(String name, List<String> values) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        this.user.getAttributes().put(name, values);
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
    }

    public String getFirstAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return null;
        }
        List attrValues = (List)this.user.getAttributes().get(name);
        return attrValues == null || attrValues.isEmpty() ? null : (String)attrValues.get(0);
    }

    public List<String> getAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return Collections.emptyList();
        }
        List attrValues = (List)this.user.getAttributes().get(name);
        return attrValues == null ? Collections.emptyList() : Collections.unmodifiableList(attrValues);
    }

    public Map<String, List<String>> getAttributes() {
        return this.user.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public Set<String> getRequiredActions() {
        ArrayList requiredActions = this.user.getRequiredActions();
        if (requiredActions == null) {
            requiredActions = new ArrayList();
        }
        return new HashSet<String>(requiredActions);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void addRequiredAction(String actionName) {
        ArrayList<String> requiredActions = this.user.getRequiredActions();
        if (requiredActions == null) {
            requiredActions = new ArrayList<String>();
        }
        if (!requiredActions.contains(actionName)) {
            requiredActions.add(actionName);
        }
        this.user.setRequiredActions(requiredActions);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void removeRequiredAction(String actionName) {
        List requiredActions = this.user.getRequiredActions();
        if (requiredActions == null) {
            return;
        }
        requiredActions.remove(actionName);
        this.user.setRequiredActions(requiredActions);
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
    }

    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            this.updatePasswordCredential(cred);
        } else {
            CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
            if (credentialEntity == null) {
                credentialEntity = this.setCredentials(this.user, cred);
                credentialEntity.setValue(cred.getValue());
                this.user.getCredentials().add(credentialEntity);
            } else {
                credentialEntity.setValue(cred.getValue());
            }
        }
    }

    private void updatePasswordCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = this.setCredentials(this.user, cred);
            this.setValue(credentialEntity, cred);
            this.user.getCredentials().add(credentialEntity);
        } else {
            int expiredPasswordsPolicyValue = -1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null) {
                expiredPasswordsPolicyValue = policy.getExpiredPasswords();
            }
            if (expiredPasswordsPolicyValue != -1) {
                this.user.getCredentials().remove(credentialEntity);
                credentialEntity.setType("password-history");
                this.user.getCredentials().add(credentialEntity);
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities.size() > expiredPasswordsPolicyValue - 1) {
                    this.user.getCredentials().removeAll(credentialEntities.subList(expiredPasswordsPolicyValue - 1, credentialEntities.size()));
                }
                credentialEntity = this.setCredentials(this.user, cred);
                this.setValue(credentialEntity, cred);
                this.user.getCredentials().add(credentialEntity);
            } else {
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities != null && credentialEntities.size() > 0) {
                    this.user.getCredentials().removeAll(credentialEntities);
                }
                this.setValue(credentialEntity, cred);
            }
        }
    }

    private CredentialEntity setCredentials(UserEntity user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = new CredentialEntity();
        credentialEntity.setType(cred.getType());
        credentialEntity.setDevice(cred.getDevice());
        return credentialEntity;
    }

    private void setValue(CredentialEntity credentialEntity, UserCredentialModel cred) {
        byte[] salt = Pbkdf2PasswordEncoder.getSalt();
        int hashIterations = 1;
        PasswordPolicy policy = this.realm.getPasswordPolicy();
        if (policy != null && (hashIterations = policy.getHashIterations()) == -1) {
            hashIterations = 1;
        }
        credentialEntity.setCreatedDate(Long.valueOf(Time.toMillis((int)Time.currentTime())));
        credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue(), hashIterations));
        credentialEntity.setSalt(salt);
        credentialEntity.setHashIterations(hashIterations);
    }

    private CredentialEntity getCredentialEntity(UserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    private List<CredentialEntity> getCredentialEntities(UserEntity userEntity, String credType) {
        ArrayList<CredentialEntity> credentialEntities = new ArrayList<CredentialEntity>();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            credentialEntities.add(entity);
        }
        Collections.sort(credentialEntities, new Comparator<CredentialEntity>(){

            @Override
            public int compare(CredentialEntity credFirst, CredentialEntity credSecond) {
                if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                    return -1;
                }
                if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                    return 1;
                }
                return 0;
            }
        });
        return credentialEntities;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        ArrayList credentials = new ArrayList(this.user.getCredentials());
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        for (CredentialEntity credEntity : credentials) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setCreatedDate(credEntity.getCreatedDate());
            credModel.setValue(credEntity.getValue());
            credModel.setSalt(credEntity.getSalt());
            credModel.setHashIterations(credEntity.getHashIterations());
            result.add(credModel);
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            credModel.setCreatedDate(credModel.getCreatedDate());
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, (RoleModel)role);
    }

    public void grantRole(RoleModel role) {
        this.allRoles.add(role);
    }

    public Set<RoleModel> getRoleMappings() {
        return Collections.unmodifiableSet(this.allRoles);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoleMappings) {
            RoleEntity roleEntity = ((RoleAdapter)role).getRoleEntity();
            if (!this.realm.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        this.allRoles.remove(role);
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (RoleModel role : this.allRoles) {
            RoleEntity roleEntity = ((RoleAdapter)role).getRoleEntity();
            if (!app.getId().equals(roleEntity.getClientId())) continue;
            result.add(new RoleAdapter(this.realm, roleEntity, (RoleContainerModel)app));
        }
        return result;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        return this.user.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.user.setServiceAccountClientLink(clientInternalId);
    }

    public void addConsent(UserConsentModel consent) {
    }

    public UserConsentModel getConsentByClient(String clientId) {
        return null;
    }

    public List<UserConsentModel> getConsents() {
        return null;
    }

    public void updateConsent(UserConsentModel consent) {
    }

    public boolean revokeConsentForClient(String clientId) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int compareTo(Object user) {
        if (this == user) {
            return 0;
        }
        return this.getUsername().compareTo(((UserModel)user).getUsername());
    }
}

