/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.keycloak.models.map.annotations.CollectionKey;
import org.keycloak.models.map.processor.FieldAccessorType;
import org.keycloak.models.map.processor.Util;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public abstract class AbstractGenerateEntityImplementationsProcessor
extends AbstractProcessor {
    protected static final String FQN_DEEP_CLONER = "org.keycloak.models.map.common.DeepCloner";
    protected static final String FQN_ENTITY_FIELD = "org.keycloak.models.map.common.EntityField";
    protected static final String FQN_HAS_ENTITY_FIELD_DELEGATE = "org.keycloak.models.map.common.delegate.HasEntityFieldDelegate";
    protected static final String FQN_ENTITY_FIELD_DELEGATE = "org.keycloak.models.map.common.delegate.EntityFieldDelegate";
    protected Elements elements;
    protected Types types;
    private static final Pattern BEAN_NAME = Pattern.compile("(get|set|is|delete|remove|add|update)([A-Z]\\S+)");
    private static final Map<String, String> FORBIDDEN_PREFIXES = new HashMap<String, String>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            annotatedElements.stream().map(TypeElement.class::cast).filter(this::testAnnotationElement).forEach(this::processTypeElement);
        }
        if (!annotations.isEmpty()) {
            this.afterAnnotationProcessing();
        }
        return true;
    }

    public ExecutableElement getCollectionKey(TypeMirror fieldType, ExecutableElement callingMethod) {
        if (!Util.isCollectionType(this.elements.getTypeElement(this.types.erasure(fieldType).toString()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid collection type: " + fieldType, callingMethod);
            return null;
        }
        TypeMirror collectionType = Util.getGenericsDeclaration(fieldType).get(0);
        TypeElement collectionTypeEl = this.elements.getTypeElement(this.types.erasure(collectionType).toString());
        Iterator it = this.elements.getAllMembers(collectionTypeEl).stream().filter(el -> el.getKind() == ElementKind.METHOD).filter(el -> el.getAnnotation(CollectionKey.class) != null).sorted(Comparator.comparing(el -> el.getAnnotation(CollectionKey.class).priority()).reversed()).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).iterator();
        ExecutableElement res = null;
        if (it.hasNext()) {
            res = (ExecutableElement)it.next();
            if (!res.getParameters().isEmpty() || !"java.lang.String".equals(res.getReturnType().toString())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid getter annotated with @CollectionKey in " + res, callingMethod);
            }
            if (it.hasNext() && ((ExecutableElement)it.next()).getAnnotation(CollectionKey.class).priority() == res.getAnnotation(CollectionKey.class).priority()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Multiple getters annotated with @CollectionKey found: " + res + ", " + it.next(), callingMethod);
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No getters annotated with @CollectionKey in " + collectionType, callingMethod);
        }
        return res;
    }

    protected boolean testAnnotationElement(TypeElement kind) {
        return true;
    }

    protected void afterAnnotationProcessing() {
    }

    protected abstract Generator[] getGenerators();

    private void processTypeElement(TypeElement e) {
        for (Generator generator : this.getGenerators()) {
            try {
                generator.generate(e);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate implementation for class: " + ex, e);
            }
        }
    }

    protected Stream<ExecutableElement> getAllAbstractMethods(TypeElement e) {
        return this.elements.getAllMembers(e).stream().filter(el -> el.getKind() == ElementKind.METHOD).filter(el -> el.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast);
    }

    protected Map<String, HashSet<ExecutableElement>> methodsPerAttributeMapping(TypeElement e) {
        Map<String, HashSet<ExecutableElement>> methodsPerAttribute = this.getAllAbstractMethods(e).filter(Util::isNotIgnored).filter(ee -> !(ee.getReceiverType() instanceof NoType) || ee.getReceiverType().getKind() == TypeKind.NONE).collect(Collectors.toMap(this::determineAttributeFromMethodName, v -> new HashSet<ExecutableElement>(Arrays.asList(v)), (a, b) -> {
            a.addAll(b);
            return a;
        }));
        methodsPerAttribute.keySet().stream().filter(key -> methodsPerAttribute.containsKey(Util.singularToPlural(key))).collect(Collectors.toSet()).forEach(key -> {
            HashSet removed = (HashSet)methodsPerAttribute.remove(key);
            ((HashSet)methodsPerAttribute.get(Util.singularToPlural(key))).addAll(removed);
        });
        return methodsPerAttribute;
    }

    protected String determineAttributeFromMethodName(ExecutableElement e) {
        Name name = e.getSimpleName();
        Matcher m = BEAN_NAME.matcher(name.toString());
        if (m.matches()) {
            String prefix = m.group(1);
            if (FORBIDDEN_PREFIXES.containsKey(prefix)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Forbidden prefix " + prefix + "... detected, use " + FORBIDDEN_PREFIXES.get(prefix) + "... instead", e);
            }
            return m.group(2);
        }
        return null;
    }

    protected Stream<ExecutableElement> fieldGetters(Map<String, HashSet<ExecutableElement>> methodsPerAttribute) {
        return methodsPerAttribute.entrySet().stream().map(me -> FieldAccessorType.getMethod(FieldAccessorType.GETTER, (HashSet)me.getValue(), (String)me.getKey(), this.types, this.determineFieldType((String)me.getKey(), (HashSet)me.getValue()))).filter(Optional::isPresent).map(Optional::get);
    }

    protected boolean isImmutableFinalType(TypeMirror fieldType) {
        return this.isPrimitiveType(fieldType) || this.isBoxedPrimitiveType(fieldType) || this.isEnumType(fieldType) || Objects.equals("java.lang.String", fieldType.toString());
    }

    protected boolean isKnownCollectionOfImmutableFinalTypes(TypeMirror fieldType) {
        List<TypeMirror> res = Util.getGenericsDeclaration(fieldType);
        return this.isCollection(fieldType) && res.stream().allMatch(this::isImmutableFinalType);
    }

    protected boolean isCollection(TypeMirror fieldType) {
        TypeElement typeElement = this.elements.getTypeElement(this.types.erasure(fieldType).toString());
        switch (typeElement.getQualifiedName().toString()) {
            case "java.util.List": 
            case "java.util.Map": 
            case "java.util.Set": 
            case "java.util.Collection": 
            case "org.keycloak.common.util.MultivaluedHashMap": {
                return true;
            }
        }
        return false;
    }

    protected String deepClone(TypeMirror fieldType, String parameterName) {
        TypeElement typeElement = this.elements.getTypeElement(this.types.erasure(fieldType).toString());
        if (this.isKnownCollectionOfImmutableFinalTypes(fieldType)) {
            return parameterName + " == null ? null : " + this.interfaceToImplementation(typeElement, parameterName);
        }
        if (Util.isMapType(typeElement)) {
            List<TypeMirror> mapTypes = Util.getGenericsDeclaration(fieldType);
            boolean isKeyImmutable = this.isImmutableFinalType(mapTypes.get(0));
            boolean isValueImmutable = this.isImmutableFinalType(mapTypes.get(1));
            return parameterName + " == null ? null : " + parameterName + ".entrySet().stream().collect(java.util.stream.Collectors.toMap(" + (String)(isKeyImmutable ? "java.util.Map.Entry::getKey" : "entry -> " + this.deepClone(mapTypes.get(0), "entry.getKey()")) + ", " + (String)(isValueImmutable ? "java.util.Map.Entry::getValue" : "entry -> " + this.deepClone(mapTypes.get(1), "entry.getValue()")) + ", (o1, o2) -> o1, java.util.HashMap::new))";
        }
        if (this.isCollection(typeElement.asType())) {
            TypeMirror collectionType = Util.getGenericsDeclaration(fieldType).get(0);
            return parameterName + " == null ? null : " + parameterName + ".stream().map(entry -> " + this.deepClone(collectionType, "entry") + ").collect(java.util.stream.Collectors.toCollection(" + (Util.isSetType(typeElement) ? "java.util.HashSet::new" : "java.util.LinkedList::new") + "))";
        }
        return "deepClone(" + parameterName + ")";
    }

    protected String removeUndefined(TypeMirror fieldType, String parameterName) {
        TypeElement typeElement = this.elements.getTypeElement(this.types.erasure(fieldType).toString());
        boolean isMapType = Util.isMapType(typeElement);
        return parameterName + (isMapType ? ".values()" : "") + ".removeIf(org.keycloak.models.map.common.UndefinedValuesUtils::isUndefined)";
    }

    protected String isUndefined(String parameterName) {
        return "org.keycloak.models.map.common.UndefinedValuesUtils.isUndefined(" + parameterName + ")";
    }

    protected boolean isEnumType(TypeMirror fieldType) {
        return this.types.asElement(fieldType).getKind() == ElementKind.ENUM;
    }

    protected boolean isPrimitiveType(TypeMirror fieldType) {
        try {
            this.types.getPrimitiveType(fieldType.getKind());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    protected boolean isBoxedPrimitiveType(TypeMirror fieldType) {
        try {
            this.types.unboxedType(fieldType);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    protected String interfaceToImplementation(TypeElement typeElement, String parameter) {
        Name parameterTypeQN = typeElement.getQualifiedName();
        switch (parameterTypeQN.toString()) {
            case "java.util.List": 
            case "java.util.Collection": {
                return "new java.util.LinkedList<>(" + parameter + ")";
            }
            case "java.util.Map": {
                return "new java.util.HashMap<>(" + parameter + ")";
            }
            case "java.util.Set": {
                return "new java.util.HashSet<>(" + parameter + ")";
            }
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not determine implementation for type " + typeElement, typeElement);
        return "TODO()";
    }

    protected TypeMirror determineFieldType(String fieldName, HashSet<ExecutableElement> methods) {
        Pattern getter = Pattern.compile("(get|is)" + Pattern.quote(fieldName));
        TypeMirror res = null;
        for (ExecutableElement method : methods) {
            if (!getter.matcher(method.getSimpleName()).matches() || !method.getParameters().isEmpty()) continue;
            return method.getReturnType();
        }
        if (res == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not determine return type for the field " + fieldName, methods.iterator().next());
        }
        return res;
    }

    protected void generatedAnnotation(PrintWriter pw) {
        pw.println("@javax.annotation.processing.Generated(\"" + this.getClass().getName() + "\")");
    }

    static {
        FORBIDDEN_PREFIXES.put("delete", "remove");
    }

    protected static class NameFirstComparator
    implements Comparator<String> {
        protected static final Comparator<String> ID_INSTANCE = new NameFirstComparator("id").thenComparing(Comparator.naturalOrder());
        protected static final Comparator<String> GET_ID_INSTANCE = new NameFirstComparator("getId").thenComparing(Comparator.naturalOrder());
        private final String name;

        public NameFirstComparator(String name) {
            this.name = name;
        }

        @Override
        public int compare(String o1, String o2) {
            return Objects.equals(o1, o2) ? 0 : (this.name.equalsIgnoreCase(o1) ? -1 : (this.name.equalsIgnoreCase(o2) ? 1 : 0));
        }
    }

    protected static interface Generator {
        public void generate(TypeElement var1) throws IOException;
    }
}

