/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.keycloak.models.map.annotations.GenerateEntityImplementations;
import org.keycloak.models.map.processor.AbstractGenerateEntityImplementationsProcessor;
import org.keycloak.models.map.processor.FieldAccessorType;
import org.keycloak.models.map.processor.PrintWriterNoJavaLang;
import org.keycloak.models.map.processor.Util;

@SupportedAnnotationTypes(value={"org.keycloak.models.map.annotations.GenerateEntityImplementations"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GenerateEntityImplementationsProcessor
extends AbstractGenerateEntityImplementationsProcessor {
    private Collection<String> cloners = new TreeSet<String>();
    private final AbstractGenerateEntityImplementationsProcessor.Generator[] generators = new AbstractGenerateEntityImplementationsProcessor.Generator[]{new ClonerGenerator(), new DelegateGenerator(), new FieldsGenerator(), new ImplGenerator()};

    @Override
    protected void afterAnnotationProcessing() {
        if (!this.cloners.isEmpty()) {
            try {
                JavaFileObject file = this.processingEnv.getFiler().createSourceFile("org.keycloak.models.map.common.AutogeneratedCloners", new Element[0]);
                try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                    ((PrintWriter)pw).println("package org.keycloak.models.map.common;");
                    ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner.Cloner;");
                    ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                    ((PrintWriter)pw).println("public final class AutogeneratedCloners {");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Cloner<?>> CLONERS_WITH_ID = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Cloner<?>> CLONERS_WITHOUT_ID = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    static {");
                    this.cloners.forEach(pw::println);
                    ((PrintWriter)pw).println("    }");
                    ((PrintWriter)pw).println("}");
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GenerateEntityImplementationsProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected AbstractGenerateEntityImplementationsProcessor.Generator[] getGenerators() {
        return this.generators;
    }

    @Override
    protected boolean testAnnotationElement(TypeElement e) {
        if (e.getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Annotation @GenerateEntityImplementations is only applicable to an interface", e);
            return false;
        }
        return true;
    }

    protected static String toEnumConstant(String key) {
        return key.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase();
    }

    private class ClonerGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private ClonerGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String clonerImplClassName = className + "Cloner";
            String clonerSimpleClassName = simpleClassName + "Cloner";
            JavaFileObject enumFile = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(clonerImplClassName, new Element[0]);
            try (PrintWriter pw = new PrintWriter(enumFile.openWriter()){

                @Override
                public void println(String x) {
                    super.println(x == null ? x : x.replaceAll("java.lang.", ""));
                }
            };){
                if (packageName != null) {
                    pw.println("package " + packageName + ";");
                }
                pw.println("import org.keycloak.models.map.common.DeepCloner;");
                pw.println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                pw.println("public class " + clonerSimpleClassName + " {");
                pw.println("    public static " + className + " deepClone(" + className + " original, " + className + " target) {");
                methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(me -> {
                    HashSet methods;
                    String fieldName = (String)me.getKey();
                    TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(fieldName, methods = (HashSet)me.getValue());
                    if (fieldType == null) {
                        return;
                    }
                    this.cloneField(e, fieldName, methods, fieldType, pw);
                });
                pw.println("        target.clearUpdatedFlag();");
                pw.println("        return target;");
                pw.println("    }");
                GenerateEntityImplementationsProcessor.this.cloners.add("        CLONERS_WITH_ID.put(" + className + ".class, (Cloner<" + className + ">) " + clonerImplClassName + "::deepClone);");
                if (methodsPerAttribute.containsKey("Id")) {
                    pw.println("    public static " + className + " deepCloneNoId(" + className + " original, " + className + " target) {");
                    methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(me -> {
                        HashSet methods;
                        String fieldName = (String)me.getKey();
                        TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(fieldName, methods = (HashSet)me.getValue());
                        if (fieldType == null || "Id".equals(fieldName)) {
                            return;
                        }
                        this.cloneField(e, fieldName, methods, fieldType, pw);
                    });
                    pw.println("        target.clearUpdatedFlag();");
                    pw.println("        return target;");
                    pw.println("    }");
                    GenerateEntityImplementationsProcessor.this.cloners.add("        CLONERS_WITHOUT_ID.put(" + className + ".class, (Cloner<" + className + ">) " + clonerImplClassName + "::deepCloneNoId);");
                }
                pw.println("}");
            }
        }

        private void cloneField(TypeElement e, String fieldName, HashSet<ExecutableElement> methods, TypeMirror fieldType, PrintWriter pw) {
            ExecutableElement getter = FieldAccessorType.getMethod(FieldAccessorType.GETTER, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType).orElse(null);
            if (getter == null) {
                GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not determine getter for " + fieldName + " property");
                return;
            }
            Optional<ExecutableElement> setter = FieldAccessorType.getMethod(FieldAccessorType.SETTER, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            Optional<ExecutableElement> addToCollection = FieldAccessorType.getMethod(FieldAccessorType.COLLECTION_ADD, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            Optional<ExecutableElement> updateMap = FieldAccessorType.getMethod(FieldAccessorType.MAP_ADD, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            if (setter.isPresent()) {
                Name setterName = setter.get().getSimpleName();
                pw.println("        target." + setterName + "(original." + getter.getSimpleName() + "());");
            } else if (addToCollection.isPresent()) {
                pw.println("        if (original." + getter.getSimpleName() + "() != null) {");
                pw.println("            original." + getter.getSimpleName() + "().forEach(target::" + addToCollection.get().getSimpleName() + ");");
                pw.println("        }");
            } else if (updateMap.isPresent()) {
                pw.println("        if (original." + getter.getSimpleName() + "() != null) {");
                pw.println("            original." + getter.getSimpleName() + "().forEach(target::" + updateMap.get().getSimpleName() + ");");
                pw.println("        }");
            } else {
                GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not determine way to clone " + fieldName + " property", e);
            }
        }
    }

    private class DelegateGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private DelegateGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapClassName = className + "Delegate";
            String mapSimpleClassName = simpleClassName + "Delegate";
            String fieldsClassName = className + "Fields";
            GenerateEntityImplementations an = e.getAnnotation(GenerateEntityImplementations.class);
            TypeElement parentTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(an.inherits() == null || an.inherits().isEmpty() ? "void" : an.inherits());
            if (parentTypeElement == null) {
                return;
            }
            List<? extends Element> allMembers = GenerateEntityImplementationsProcessor.this.elements.getAllMembers(e);
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapClassName, new Element[0]);
            IdentityHashMap m2field = new IdentityHashMap();
            methodsPerAttribute.forEach((f, s) -> s.forEach(m -> m2field.put(m, f)));
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("public class " + mapSimpleClassName + " implements " + className + " {");
                ((PrintWriter)pw).println("    private final org.keycloak.models.map.common.delegate.DelegateProvider<" + className + "> delegateProvider;");
                ((PrintWriter)pw).println("    public " + mapSimpleClassName + "(org.keycloak.models.map.common.delegate.DelegateProvider<" + className + "> delegateProvider) {");
                ((PrintWriter)pw).println("        this.delegateProvider = delegateProvider;");
                ((PrintWriter)pw).println("    }");
                allMembers.stream().filter(m -> m.getKind() == ElementKind.METHOD).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> ee.getModifiers().contains((Object)Modifier.ABSTRACT)).forEach(ee -> {
                    pw.println("    @Override " + ee.getModifiers().stream().filter(m -> m != Modifier.ABSTRACT).map(Object::toString).collect(Collectors.joining(" ")) + " " + ee.getReturnType() + " " + ee.getSimpleName() + "(" + Util.methodParameters(ee.getParameters()) + ") {");
                    String field = (String)m2field.get(ee);
                    String string = field = field == null ? "null" : fieldsClassName + "." + GenerateEntityImplementationsProcessor.toEnumConstant(field);
                    if (ee.getReturnType().getKind() == TypeKind.BOOLEAN && "isUpdated".equals(ee.getSimpleName().toString())) {
                        pw.println("        return delegateProvider.isUpdated();");
                    } else if (ee.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("        delegateProvider.getDelegate(false, " + field + ")." + ee.getSimpleName() + "(" + ee.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.joining(", ")) + ");");
                    } else {
                        pw.println("        return delegateProvider.getDelegate(true, " + field + ")." + ee.getSimpleName() + "(" + ee.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.joining(", ")) + ");");
                    }
                    pw.println("    }");
                });
                ((PrintWriter)pw).println("}");
            }
        }
    }

    private class ImplGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private ImplGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            GenerateEntityImplementations an = e.getAnnotation(GenerateEntityImplementations.class);
            TypeElement parentTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(an.inherits() == null || an.inherits().isEmpty() ? "void" : an.inherits());
            if (parentTypeElement == null) {
                return;
            }
            List<? extends Element> allMembers = GenerateEntityImplementationsProcessor.this.elements.getAllMembers(parentTypeElement);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapImplClassName = className + "Impl";
            String mapSimpleClassName = simpleClassName + "Impl";
            boolean hasId = methodsPerAttribute.containsKey("Id") || allMembers.stream().anyMatch(el -> "getId".equals(el.getSimpleName().toString()));
            boolean hasDeepClone = allMembers.stream().filter(el -> el.getKind() == ElementKind.METHOD).anyMatch(el -> "deepClone".equals(el.getSimpleName().toString()));
            boolean needsDeepClone = GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getReturnType).anyMatch(fieldType -> !GenerateEntityImplementationsProcessor.this.isKnownCollectionOfImmutableFinalTypes((TypeMirror)fieldType) && !GenerateEntityImplementationsProcessor.this.isImmutableFinalType((TypeMirror)fieldType));
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapImplClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("import java.util.Objects;");
                ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner;");
                ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                ((PrintWriter)pw).println("public class " + mapSimpleClassName + (an.inherits().isEmpty() ? "" : " extends " + an.inherits()) + " implements " + className + " {");
                allMembers.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> ee.getKind() == ElementKind.CONSTRUCTOR).forEach(ee -> {
                    if (hasDeepClone || !needsDeepClone) {
                        pw.println("    " + ee.getModifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " " + mapSimpleClassName + "(" + Util.methodParameters(ee.getParameters()) + ") { super(" + ee.getParameters() + "); }");
                    } else if (needsDeepClone) {
                        pw.println("    /**");
                        pw.println("     * @deprecated This constructor uses a {@link DeepCloner#DUMB_CLONER} that does not clone anything. Use {@link #" + mapSimpleClassName + "(DeepCloner)} variant instead");
                        pw.println("     */");
                        pw.println("    " + ee.getModifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " " + mapSimpleClassName + "(" + Util.methodParameters(ee.getParameters()) + ") { this(DeepCloner.DUMB_CLONER" + (ee.getParameters().isEmpty() ? "" : ", ") + ee.getParameters() + "); }");
                        pw.println("    " + ee.getModifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " " + mapSimpleClassName + "(DeepCloner cloner" + (ee.getParameters().isEmpty() ? "" : ", ") + Util.methodParameters(ee.getParameters()) + ") { super(" + ee.getParameters() + "); this.cloner = cloner; }");
                    }
                });
                ((PrintWriter)pw).println("    @Override public boolean equals(Object o) {");
                ((PrintWriter)pw).println("        if (o == this) return true; ");
                ((PrintWriter)pw).println("        if (! (o instanceof " + mapSimpleClassName + ")) return false; ");
                ((PrintWriter)pw).println("        " + mapSimpleClassName + " other = (" + mapSimpleClassName + ") o; ");
                ((PrintWriter)pw).println("        return " + GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> "Objects.equals(" + v + "(), other." + v + "())").collect(Collectors.joining("\n          && ")) + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public int hashCode() {");
                ((PrintWriter)pw).println("        return " + (hasId ? "(getId() == null ? super.hashCode() : getId().hashCode())" : "Objects.hash(" + GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).filter(ee -> GenerateEntityImplementationsProcessor.this.isImmutableFinalType(ee.getReturnType())).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> v + "()").collect(Collectors.joining(",\n          ")) + ")") + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public String toString() {");
                ((PrintWriter)pw).println("        return String.format(\"%s@%08x\", " + (hasId ? "getId()" : "\"" + mapSimpleClassName + "\"") + ", System.identityHashCode(this));");
                ((PrintWriter)pw).println("    }");
                if (!hasDeepClone && needsDeepClone) {
                    ((PrintWriter)pw).println("    private final DeepCloner cloner;");
                    ((PrintWriter)pw).println("    public <V> V deepClone(V obj) {");
                    ((PrintWriter)pw).println("        return cloner.from(obj);");
                    ((PrintWriter)pw).println("    }");
                }
                methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE)).forEach(me -> {
                    HashSet methods = (HashSet)me.getValue();
                    TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType((String)me.getKey(), methods);
                    if (fieldType == null) {
                        return;
                    }
                    pw.println("");
                    pw.println("    private " + fieldType + " f" + (String)me.getKey() + ";");
                    for (ExecutableElement method : methods) {
                        FieldAccessorType fat = FieldAccessorType.determineType(method, (String)me.getKey(), GenerateEntityImplementationsProcessor.this.types, fieldType);
                        Optional<ExecutableElement> parentMethod = allMembers.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> Objects.equals(ee.toString(), method.toString())).filter(ee -> !ee.getModifiers().contains((Object)Modifier.ABSTRACT)).findAny();
                        if (parentMethod.isPresent()) {
                            GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Method " + method + " is declared in a parent class.", method);
                            continue;
                        }
                        if (fat == FieldAccessorType.UNKNOWN || this.printMethodBody(pw, fat, method, "f" + (String)me.getKey(), fieldType)) continue;
                        GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not determine desired semantics of method from its signature", method);
                    }
                });
                ((PrintWriter)pw).println("}");
            }
        }

        private boolean printMethodBody(PrintWriter pw, FieldAccessorType accessorType, ExecutableElement method, String fieldName, TypeMirror fieldType) {
            NullType firstParameterType = method.getParameters().isEmpty() ? GenerateEntityImplementationsProcessor.this.types.getNullType() : method.getParameters().get(0).asType();
            TypeElement typeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType).toString());
            switch (accessorType) {
                case GETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method + " {");
                    pw.println("        return " + fieldName + ";");
                    pw.println("    }");
                    return true;
                }
                case SETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(fieldType)) {
                        pw.println("        p0 = " + GenerateEntityImplementationsProcessor.this.deepClone(fieldType, "p0") + ";");
                    }
                    pw.println("        updated |= ! Objects.equals(" + fieldName + ", p0);");
                    pw.println("        " + fieldName + " = p0;");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_ADD: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        if (" + fieldName + " == null) { " + fieldName + " = " + GenerateEntityImplementationsProcessor.this.interfaceToImplementation(typeElement, "") + "; }");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(firstParameterType)) {
                        pw.println("        p0 = " + GenerateEntityImplementationsProcessor.this.deepClone(fieldType, "p0") + ";");
                    }
                    if (Util.isSetType(typeElement)) {
                        pw.println("        updated |= " + fieldName + ".add(p0);");
                    } else {
                        pw.println("        " + fieldName + ".add(p0);");
                        pw.println("        updated = true;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        if (" + fieldName + " == null) { return; }");
                    pw.println("        boolean removed = " + fieldName + ".remove(p0)" + ("java.util.Map".equals(typeElement.getQualifiedName().toString()) ? " != null" : "") + ";");
                    pw.println("        updated |= removed;");
                    pw.println("    }");
                    return true;
                }
                case MAP_ADD: {
                    TypeMirror secondParameterType = method.getParameters().get(1).asType();
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0, " + secondParameterType + " p1) {");
                    pw.println("        if (" + fieldName + " == null) { " + fieldName + " = " + GenerateEntityImplementationsProcessor.this.interfaceToImplementation(typeElement, "") + "; }");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(secondParameterType)) {
                        pw.println("        p1 = " + GenerateEntityImplementationsProcessor.this.deepClone(secondParameterType, "p1") + ";");
                    }
                    pw.println("        Object v = " + fieldName + ".put(p0, p1);");
                    pw.println("        updated |= ! Objects.equals(v, p1);");
                    pw.println("    }");
                    return true;
                }
                case MAP_GET: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        return " + fieldName + " == null ? null : " + fieldName + ".get(p0);");
                    pw.println("    }");
                    return true;
                }
            }
            return false;
        }
    }

    private class FieldsGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private FieldsGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapFieldsClassName = className + "Fields";
            String mapSimpleFieldsClassName = simpleClassName + "Fields";
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapFieldsClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("public enum " + mapSimpleFieldsClassName + " {");
                methodsPerAttribute.keySet().stream().sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE).map(GenerateEntityImplementationsProcessor::toEnumConstant).forEach(key -> pw.println("    " + key + ","));
                ((PrintWriter)pw).println("}");
            }
        }
    }
}

