/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.session;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.util.JsonSerialization;

public class PersistentClientSessionAdapter
implements ClientSessionModel {
    private final PersistentClientSessionModel model;
    private final RealmModel realm;
    private final ClientModel client;
    private UserSessionModel userSession;
    private PersistentClientSessionData data;

    public PersistentClientSessionAdapter(ClientSessionModel clientSession) {
        this.data = new PersistentClientSessionData();
        this.data.setAction(clientSession.getAction());
        this.data.setAuthMethod(clientSession.getAuthMethod());
        this.data.setExecutionStatus(clientSession.getExecutionStatus());
        this.data.setNotes(clientSession.getNotes());
        this.data.setProtocolMappers(clientSession.getProtocolMappers());
        this.data.setRedirectUri(clientSession.getRedirectUri());
        this.data.setRoles(clientSession.getRoles());
        this.data.setUserSessionNotes(clientSession.getUserSessionNotes());
        this.model = new PersistentClientSessionModel();
        this.model.setClientId(clientSession.getClient().getId());
        this.model.setClientSessionId(clientSession.getId());
        if (clientSession.getAuthenticatedUser() != null) {
            this.model.setUserId(clientSession.getAuthenticatedUser().getId());
        }
        this.model.setUserSessionId(clientSession.getUserSession().getId());
        this.model.setTimestamp(clientSession.getTimestamp());
        this.realm = clientSession.getRealm();
        this.client = clientSession.getClient();
        this.userSession = clientSession.getUserSession();
    }

    public PersistentClientSessionAdapter(PersistentClientSessionModel model, RealmModel realm, ClientModel client, UserSessionModel userSession) {
        this.model = model;
        this.realm = realm;
        this.client = client;
        this.userSession = userSession;
    }

    private PersistentClientSessionData getData() {
        if (this.data == null) {
            try {
                this.data = (PersistentClientSessionData)JsonSerialization.readValue((String)this.model.getData(), PersistentClientSessionData.class);
            }
            catch (IOException ioe) {
                throw new ModelException(ioe);
            }
        }
        return this.data;
    }

    public PersistentClientSessionModel getUpdatedModel() {
        try {
            String updatedData = JsonSerialization.writeValueAsString((Object)this.getData());
            this.model.setData(updatedData);
        }
        catch (IOException ioe) {
            throw new ModelException(ioe);
        }
        return this.model;
    }

    @Override
    public String getId() {
        return this.model.getClientSessionId();
    }

    @Override
    public RealmModel getRealm() {
        return this.realm;
    }

    @Override
    public ClientModel getClient() {
        return this.client;
    }

    @Override
    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    @Override
    public void setUserSession(UserSessionModel userSession) {
        this.userSession = userSession;
    }

    @Override
    public String getRedirectUri() {
        return this.getData().getRedirectUri();
    }

    @Override
    public void setRedirectUri(String uri) {
        this.getData().setRedirectUri(uri);
    }

    @Override
    public int getTimestamp() {
        return this.model.getTimestamp();
    }

    @Override
    public void setTimestamp(int timestamp) {
        this.model.setTimestamp(timestamp);
    }

    @Override
    public String getAction() {
        return this.getData().getAction();
    }

    @Override
    public void setAction(String action) {
        this.getData().setAction(action);
    }

    @Override
    public Set<String> getRoles() {
        return this.getData().getRoles();
    }

    @Override
    public void setRoles(Set<String> roles) {
        this.getData().setRoles(roles);
    }

    @Override
    public Set<String> getProtocolMappers() {
        return this.getData().getProtocolMappers();
    }

    @Override
    public void setProtocolMappers(Set<String> protocolMappers) {
        this.getData().setProtocolMappers(protocolMappers);
    }

    @Override
    public Map<String, ClientSessionModel.ExecutionStatus> getExecutionStatus() {
        return this.getData().getExecutionStatus();
    }

    @Override
    public void setExecutionStatus(String authenticator, ClientSessionModel.ExecutionStatus status) {
        this.getData().getExecutionStatus().put(authenticator, status);
    }

    @Override
    public void clearExecutionStatus() {
        this.getData().getExecutionStatus().clear();
    }

    @Override
    public UserModel getAuthenticatedUser() {
        return this.userSession.getUser();
    }

    @Override
    public void setAuthenticatedUser(UserModel user) {
        throw new IllegalStateException("Not supported setAuthenticatedUser");
    }

    @Override
    public String getAuthMethod() {
        return this.getData().getAuthMethod();
    }

    @Override
    public void setAuthMethod(String method) {
        this.getData().setAuthMethod(method);
    }

    @Override
    public String getNote(String name) {
        PersistentClientSessionData entity = this.getData();
        return entity.getNotes() == null ? null : entity.getNotes().get(name);
    }

    @Override
    public void setNote(String name, String value) {
        PersistentClientSessionData entity = this.getData();
        if (entity.getNotes() == null) {
            entity.setNotes(new HashMap<String, String>());
        }
        entity.getNotes().put(name, value);
    }

    @Override
    public void removeNote(String name) {
        PersistentClientSessionData entity = this.getData();
        if (entity.getNotes() != null) {
            entity.getNotes().remove(name);
        }
    }

    @Override
    public Map<String, String> getNotes() {
        PersistentClientSessionData entity = this.getData();
        if (entity.getNotes() == null || entity.getNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        return entity.getNotes();
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.getData().getRequiredActions();
    }

    @Override
    public void addRequiredAction(String action) {
        this.getData().getRequiredActions().add(action);
    }

    @Override
    public void removeRequiredAction(String action) {
        this.getData().getRequiredActions().remove(action);
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        this.addRequiredAction(action.name());
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.removeRequiredAction(action.name());
    }

    @Override
    public void setUserSessionNote(String name, String value) {
        PersistentClientSessionData entity = this.getData();
        if (entity.getUserSessionNotes() == null) {
            entity.setUserSessionNotes(new HashMap<String, String>());
        }
        entity.getUserSessionNotes().put(name, value);
    }

    @Override
    public Map<String, String> getUserSessionNotes() {
        PersistentClientSessionData entity = this.getData();
        if (entity.getUserSessionNotes() == null || entity.getUserSessionNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        return entity.getUserSessionNotes();
    }

    @Override
    public void clearUserSessionNotes() {
        PersistentClientSessionData entity = this.getData();
        entity.setUserSessionNotes(new HashMap<String, String>());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientSessionModel)) {
            return false;
        }
        ClientSessionModel that = (ClientSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected static class PersistentClientSessionData {
        @JsonProperty(value="authMethod")
        private String authMethod;
        @JsonProperty(value="redirectUri")
        private String redirectUri;
        @JsonProperty(value="protocolMappers")
        private Set<String> protocolMappers;
        @JsonProperty(value="roles")
        private Set<String> roles;
        @JsonProperty(value="notes")
        private Map<String, String> notes;
        @JsonProperty(value="userSessionNotes")
        private Map<String, String> userSessionNotes;
        @JsonProperty(value="executionStatus")
        private Map<String, ClientSessionModel.ExecutionStatus> executionStatus = new HashMap<String, ClientSessionModel.ExecutionStatus>();
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="requiredActions")
        private Set<String> requiredActions = new HashSet<String>();

        protected PersistentClientSessionData() {
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        public Set<String> getProtocolMappers() {
            return this.protocolMappers;
        }

        public void setProtocolMappers(Set<String> protocolMappers) {
            this.protocolMappers = protocolMappers;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        public Map<String, String> getNotes() {
            return this.notes;
        }

        public void setNotes(Map<String, String> notes) {
            this.notes = notes;
        }

        public Map<String, String> getUserSessionNotes() {
            return this.userSessionNotes;
        }

        public void setUserSessionNotes(Map<String, String> userSessionNotes) {
            this.userSessionNotes = userSessionNotes;
        }

        public Map<String, ClientSessionModel.ExecutionStatus> getExecutionStatus() {
            return this.executionStatus;
        }

        public void setExecutionStatus(Map<String, ClientSessionModel.ExecutionStatus> executionStatus) {
            this.executionStatus = executionStatus;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Set<String> getRequiredActions() {
            return this.requiredActions;
        }

        public void setRequiredActions(Set<String> requiredActions) {
            this.requiredActions = requiredActions;
        }
    }
}

