/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.UserAttributeLDAPFederationMapper;
import org.keycloak.mappers.FederationConfigValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "user-attribute-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "Used to map single attribute from LDAP user to attribute of UserModel in Keycloak DB";
    }

    public String getDisplayCategory() {
        return "Attribute Mapper";
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public Map<String, String> getDefaultConfig(UserFederationProviderModel providerModel) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        LDAPConfig config = new LDAPConfig(providerModel.getConfig());
        String readOnly = config.getEditMode() == UserFederationProvider.EditMode.WRITABLE ? "false" : "true";
        defaultValues.put("read.only", readOnly);
        defaultValues.put("always.read.value.from.ldap", "false");
        defaultValues.put("is.mandatory.in.ldap", "false");
        return defaultValues;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfig(RealmModel realm, UserFederationProviderModel fedProviderModel, UserFederationMapperModel mapperModel) throws FederationConfigValidationException {
        this.checkMandatoryConfigAttribute("user.model.attribute", "User Model Attribute", mapperModel);
        this.checkMandatoryConfigAttribute("ldap.attribute", "LDAP Attribute", mapperModel);
    }

    @Override
    protected AbstractLDAPFederationMapper createMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider federationProvider, RealmModel realm) {
        return new UserAttributeLDAPFederationMapper(mapperModel, federationProvider, realm);
    }

    static {
        ProviderConfigProperty userModelAttribute = UserAttributeLDAPFederationMapperFactory.createConfigProperty("user.model.attribute", "User Model Attribute", "Name of mapped UserModel property or UserModel attribute in Keycloak DB. For example 'firstName', 'lastName, 'email', 'street' etc.", "String", null);
        configProperties.add(userModelAttribute);
        ProviderConfigProperty ldapAttribute = UserAttributeLDAPFederationMapperFactory.createConfigProperty("ldap.attribute", "LDAP Attribute", "Name of mapped attribute on LDAP object. For example 'cn', 'sn, 'mail', 'street' etc.", "String", null);
        configProperties.add(ldapAttribute);
        ProviderConfigProperty readOnly = UserAttributeLDAPFederationMapperFactory.createConfigProperty("read.only", "Read Only", "Read-only attribute is imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.", "boolean", null);
        configProperties.add(readOnly);
        ProviderConfigProperty alwaysReadValueFromLDAP = UserAttributeLDAPFederationMapperFactory.createConfigProperty("always.read.value.from.ldap", "Always Read Value From LDAP", "If on, then during reading of the user will be value of attribute from LDAP always used instead of the value from Keycloak DB", "boolean", null);
        configProperties.add(alwaysReadValueFromLDAP);
        ProviderConfigProperty isMandatoryInLdap = UserAttributeLDAPFederationMapperFactory.createConfigProperty("is.mandatory.in.ldap", "Is Mandatory In LDAP", "If true, attribute is mandatory in LDAP. Hence if there is no value in Keycloak DB, the empty value will be set to be propagated to LDAP", "boolean", null);
        configProperties.add(isMandatoryInLdap);
    }
}

