/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import io.quarkus.deployment.util.FileUtil;
import io.quarkus.fs.util.ZipUtils;
import io.restassured.RestAssured;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.awaitility.Awaitility;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.keycloak.common.Version;
import org.keycloak.it.TestProvider;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.Maven;
import org.keycloak.it.utils.OutputConsumer;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public final class RawKeycloakDistribution
implements KeycloakDistribution {
    private static final int DEFAULT_SHUTDOWN_TIMEOUT_SECONDS = 10;
    private static final Logger LOG = Logger.getLogger(RawKeycloakDistribution.class);
    private Process keycloak;
    private int exitCode = -1;
    private final Path distPath;
    private boolean manualStop;
    private String relativePath;
    private int httpPort;
    private int httpsPort;
    private final boolean debug;
    private final boolean enableTls;
    private final boolean reCreate;
    private final boolean removeBuildOptionsAfterBuild;
    private final int requestPort;
    private ExecutorService outputExecutor;
    private boolean inited = false;
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final OutputConsumer outputConsumer;

    public RawKeycloakDistribution(boolean debug, boolean manualStop, boolean enableTls, boolean reCreate, boolean removeBuildOptionsAfterBuild, int requestPort) {
        this(debug, manualStop, enableTls, reCreate, removeBuildOptionsAfterBuild, requestPort, new DefaultOutputConsumer());
    }

    public RawKeycloakDistribution(boolean debug, boolean manualStop, boolean enableTls, boolean reCreate, boolean removeBuildOptionsAfterBuild, int requestPort, OutputConsumer outputConsumer) {
        this.debug = debug;
        this.manualStop = manualStop;
        this.enableTls = enableTls;
        this.reCreate = reCreate;
        this.removeBuildOptionsAfterBuild = removeBuildOptionsAfterBuild;
        this.requestPort = requestPort;
        this.distPath = this.prepareDistribution();
        this.outputConsumer = outputConsumer;
    }

    public CLIResult kcadm(String ... arguments) throws IOException {
        return this.kcadm(Arrays.asList(arguments));
    }

    public CLIResult kcadm(List<String> arguments) throws IOException {
        ArrayList<String> allArgs = new ArrayList<String>();
        this.invoke(allArgs, SCRIPT_KCADM_CMD);
        if (this.isDebug()) {
            allArgs.add("-x");
        }
        allArgs.addAll(arguments);
        ProcessBuilder pb = new ProcessBuilder(allArgs);
        ProcessBuilder builder = pb.directory(this.distPath.resolve("bin").toFile());
        builder.environment().putAll(this.envVars);
        Process kcadm = builder.start();
        DefaultOutputConsumer outputConsumer = new DefaultOutputConsumer();
        this.readOutput(kcadm, outputConsumer);
        int exitValue = kcadm.exitValue();
        return CLIResult.create(outputConsumer.getStdOut(), outputConsumer.getErrOut(), exitValue);
    }

    private void invoke(List<String> allArgs, String cmd) {
        if (Environment.isWindows()) {
            allArgs.add(String.valueOf(this.distPath.resolve("bin")) + File.separator + cmd);
        } else {
            allArgs.add("./" + cmd);
        }
    }

    @Override
    public CLIResult run(List<String> arguments) {
        this.stop();
        if (this.manualStop && this.isRunning()) {
            throw new IllegalStateException("Server already running. You should manually stop the server before starting it again.");
        }
        this.reset();
        try {
            this.configureServer();
            this.startServer(arguments);
            if (this.manualStop) {
                this.asyncReadOutput();
                this.waitForReadiness();
            } else {
                this.readOutput();
            }
        }
        catch (Exception cause) {
            try {
                this.stop();
            }
            catch (Exception stopException) {
                cause.addSuppressed(stopException);
            }
            throw new RuntimeException("Failed to start the server", cause);
        }
        finally {
            if (arguments.contains("build") && this.removeBuildOptionsAfterBuild) {
                for (List mappers : PropertyMappers.getBuildTimeMappers().values()) {
                    for (PropertyMapper mapper : mappers) {
                        this.removeProperty(mapper.getFrom().substring(3));
                    }
                }
            }
            if (!this.manualStop) {
                this.stop();
            }
        }
        this.setRequestPort();
        return CLIResult.create(this.getOutputStream(), this.getErrorStream(), this.getExitCode());
    }

    private void configureServer() {
        if (this.enableTls) {
            this.copyOrReplaceFileFromClasspath("/server.keystore", Path.of("conf", "server.keystore"));
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            try {
                this.destroyDescendantsOnWindows(this.keycloak, false);
                this.keycloak.destroy();
                this.keycloak.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (Exception cause) {
                this.destroyDescendantsOnWindows(this.keycloak, true);
                this.keycloak.destroyForcibly();
                this.threadDump();
                throw new RuntimeException("Failed to stop the server", cause);
            }
        }
        if (this.keycloak != null) {
            this.exitCode = this.keycloak.exitValue();
        }
        this.shutdownOutputExecutor();
    }

    private void destroyDescendantsOnWindows(Process parent, boolean force) {
        if (!Environment.isWindows()) {
            return;
        }
        List<ProcessHandle> descendants = parent.descendants().toList();
        if (descendants.isEmpty()) {
            return;
        }
        LOG.debugf("Found %d descendant processes to terminate", descendants.size());
        CompletableFuture<Object> allProcesses = CompletableFuture.completedFuture(null);
        for (ProcessHandle process : descendants) {
            if (force) {
                LOG.warn((Object)"Using forcible termination of descendant processes after normal termination failed");
                LOG.debugf("Forcibly terminating process %s", process.pid());
                process.destroyForcibly();
            } else {
                process.destroy();
            }
            allProcesses = CompletableFuture.allOf(allProcesses, process.onExit());
        }
        try {
            allProcesses.get(10L, TimeUnit.SECONDS);
            LOG.debugf("All descendant processes terminated according to Java", new Object[0]);
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to terminate descendants processes", cause);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public List<String> getOutputStream() {
        return this.outputConsumer.getStdOut();
    }

    @Override
    public List<String> getErrorStream() {
        return this.outputConsumer.getErrOut();
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }

    @Override
    public String[] getCliArgs(List<String> arguments) {
        ArrayList<String> allArgs = new ArrayList<String>();
        this.invoke(allArgs, SCRIPT_CMD);
        if (this.isDebug()) {
            allArgs.add("--debug");
        }
        if (!this.isManualStop()) {
            allArgs.add("-Dkc.launch.mode=test");
        }
        allArgs.add("-Djgroups.join_timeout=50");
        this.relativePath = arguments.stream().filter(arg -> arg.startsWith("--http-relative-path")).map(arg -> arg.substring(arg.indexOf(61) + 1)).findAny().orElse("/");
        this.httpPort = Integer.parseInt(arguments.stream().filter(arg -> arg.startsWith("--http-port")).map(arg -> arg.substring(arg.indexOf(61) + 1)).findAny().orElse("8080"));
        this.httpsPort = Integer.parseInt(arguments.stream().filter(arg -> arg.startsWith("--https-port")).map(arg -> arg.substring(arg.indexOf(61) + 1)).findAny().orElse("8443"));
        allArgs.add("-Dkc.home.dir=" + String.valueOf(this.distPath) + File.separator);
        allArgs.addAll(arguments);
        return (String[])allArgs.toArray(String[]::new);
    }

    @Override
    public void setRequestPort() {
        this.setRequestPort(this.requestPort);
    }

    @Override
    public void setRequestPort(int port) {
        RestAssured.port = port;
    }

    private void waitForReadiness() throws MalformedURLException {
        this.waitForReadiness("http", this.httpPort);
        if (this.enableTls) {
            this.waitForReadiness("https", this.httpsPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReadiness(String scheme, int port) throws MalformedURLException {
        Object myRelativePath = this.relativePath;
        if (!((String)myRelativePath).endsWith("/")) {
            myRelativePath = (String)myRelativePath + "/";
        }
        URL contextRoot = new URL(scheme + "://localhost:" + port + (String)myRelativePath + "realms/master/");
        HttpURLConnection connection = null;
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        while (true) {
            if (System.currentTimeMillis() - startTime > this.getStartTimeout()) {
                this.threadDump();
                throw new IllegalStateException("Timeout [" + this.getStartTimeout() + "] while waiting for Quarkus server", ex);
            }
            if (!this.keycloak.isAlive()) {
                return;
            }
            try {
                if ("https".equals(contextRoot.getProtocol())) {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    httpsConnection.setSSLSocketFactory(this.createInsecureSslSocketFactory());
                    httpsConnection.setHostnameVerifier(this.createInsecureHostnameVerifier());
                } else {
                    connection = (HttpURLConnection)contextRoot.openConnection();
                }
                connection.setReadTimeout((int)this.getStartTimeout());
                connection.setConnectTimeout((int)this.getStartTimeout());
                connection.connect();
                if (connection.getResponseCode() != 200) continue;
            }
            catch (Exception ignore) {
                ex = ignore;
                continue;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }

    private void threadDump() {
        if (Environment.isWindows()) {
            return;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder("kill", "-3", String.valueOf(this.keycloak.pid()));
            Process p = builder.start();
            p.onExit().get(this.getStartTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOG.warn((Object)"A thread dump may not have been successfully triggered", (Throwable)e);
            return;
        }
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).until(() -> this.getOutputStream().stream().anyMatch(s -> s.contains("JNI global refs")));
    }

    private long getStartTimeout() {
        return TimeUnit.SECONDS.toMillis(Long.getLong("keycloak.distribution.start.timeout", 120L));
    }

    private HostnameVerifier createInsecureHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    private SSLSocketFactory createInsecureSslSocketFactory() throws IOException {
        SSLSocketFactory socketFactory;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            socketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException("Can't create unsecure trust manager");
        }
        return socketFactory;
    }

    private boolean isRunning() {
        return this.keycloak != null && this.keycloak.isAlive();
    }

    private void asyncReadOutput() {
        this.shutdownOutputExecutor();
        this.outputExecutor = Executors.newSingleThreadExecutor();
        this.outputExecutor.execute(this::readOutput);
    }

    private void shutdownOutputExecutor() {
        if (this.outputExecutor != null) {
            this.outputExecutor.shutdown();
            try {
                this.outputExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException cause) {
                throw new RuntimeException("Failed to terminate output executor", cause);
            }
            finally {
                this.outputExecutor = null;
            }
        }
    }

    private void reset() {
        this.outputConsumer.reset();
        this.exitCode = -1;
        this.shutdownOutputExecutor();
        this.keycloak = null;
    }

    private Path prepareDistribution() {
        try {
            String distDirName;
            Path distRootPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("kc-tests");
            distRootPath.toFile().mkdirs();
            File distFile = new File("../../dist/" + File.separator + "target" + File.separator + "keycloak-" + Version.VERSION + ".zip");
            if (distFile.exists()) {
                distDirName = distFile.getName();
            } else {
                distFile = Maven.resolveArtifact("org.keycloak", "keycloak-quarkus-dist").toFile();
                distDirName = distFile.getName().replace("-quarkus-dist", "");
            }
            distRootPath.toFile().mkdirs();
            Path dPath = distRootPath.resolve(distDirName.substring(0, distDirName.lastIndexOf(46)));
            if (!this.inited || this.reCreate || !dPath.toFile().exists()) {
                FileUtil.deleteDirectory((Path)dPath);
                ZipUtils.unzip((Path)distFile.toPath(), (Path)distRootPath);
                if (System.getProperty("product") != null) {
                    RawKeycloakDistribution.copyProvider(dPath, "com.microsoft.sqlserver", "mssql-jdbc");
                }
            }
            if (!dPath.resolve("bin").resolve(SCRIPT_CMD).toFile().setExecutable(true)) {
                throw new RuntimeException("Cannot set " + SCRIPT_CMD + " executable");
            }
            if (!dPath.resolve("bin").resolve(SCRIPT_KCADM_CMD).toFile().setExecutable(true)) {
                throw new RuntimeException("Cannot set " + SCRIPT_KCADM_CMD + " executable");
            }
            this.inited = true;
            return dPath;
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to prepare distribution", cause);
        }
    }

    private void readOutput() {
        this.readOutput(this.keycloak, this.outputConsumer);
    }

    private void readOutput(Process process, OutputConsumer outputConsumer) {
        try (BufferedReader outStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
             BufferedReader errStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            while (process.isAlive()) {
                this.readStream(outStream, outputConsumer, false);
                this.readStream(errStream, outputConsumer, true);
                LockSupport.parkNanos(1L);
            }
        }
        catch (Throwable cause) {
            throw new RuntimeException("Failed to read server output", cause);
        }
    }

    private void readStream(BufferedReader reader, OutputConsumer outputConsumer, boolean error) throws IOException {
        String line;
        while (reader.ready() && (line = reader.readLine()) != null) {
            if (error) {
                outputConsumer.onErrOut(line);
                continue;
            }
            outputConsumer.onStdOut(line);
        }
    }

    private void startServer(List<String> arguments) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(this.getCliArgs(arguments));
        ProcessBuilder builder = pb.directory(this.distPath.resolve("bin").toFile());
        if (this.debug) {
            builder.environment().put("DEBUG_SUSPEND", "y");
        }
        builder.environment().putAll(this.envVars);
        this.keycloak = builder.start();
    }

    @Override
    public void setManualStop(boolean manualStop) {
        this.manualStop = manualStop;
    }

    @Override
    public void setProperty(String key, String value) {
        this.updateProperties(properties -> properties.put(key, value), this.distPath.resolve("conf").resolve("keycloak.conf").toFile());
    }

    @Override
    public void setEnvVar(String name, String value) {
        this.envVars.put(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.updateProperties(properties -> properties.remove(name), this.distPath.resolve("conf").resolve("keycloak.conf").toFile());
    }

    @Override
    public void setQuarkusProperty(String key, String value) {
        this.updateProperties(properties -> properties.put(key, value), this.getQuarkusPropertiesFile());
    }

    @Override
    public void deleteQuarkusProperties() {
        File file = this.getQuarkusPropertiesFile();
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void copyOrReplaceFileFromClasspath(String file, Path targetFile) {
        File targetDir = this.distPath.resolve(targetFile).toFile();
        targetDir.mkdirs();
        try {
            Files.copy(this.getClass().getResourceAsStream(file), targetDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to copy file", cause);
        }
    }

    @Override
    public void copyOrReplaceFile(Path file, Path targetFile) {
        if (!file.toFile().exists()) {
            return;
        }
        File targetDir = this.distPath.resolve(targetFile).toFile();
        targetDir.mkdirs();
        try {
            Files.copy(file, targetDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to copy file", cause);
        }
    }

    public void copyProvider(String groupId, String artifactId) {
        RawKeycloakDistribution.copyProvider(this.getDistPath(), groupId, artifactId);
    }

    private static void copyProvider(Path distPath, String groupId, String artifactId) {
        try {
            Path providerPath = Maven.resolveArtifact(groupId, artifactId);
            if (!Files.isRegularFile(providerPath, new LinkOption[0])) {
                throw new RuntimeException("Failed to copy JAR file to 'providers' directory; " + String.valueOf(providerPath) + " is not a file");
            }
            Files.copy(providerPath, distPath.resolve("providers").resolve(artifactId + ".jar"), new CopyOption[0]);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to copy JAR file to 'providers' directory", cause);
        }
    }

    public void copyConfigFile(Path configFilePath) {
        try {
            Files.copy(configFilePath, this.distPath.resolve("conf").resolve(configFilePath.getFileName()), new CopyOption[0]);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to copy config file [" + String.valueOf(configFilePath) + "] to 'conf' directory", cause);
        }
    }

    private void updateProperties(Consumer<Properties> propertiesConsumer, File propertiesFile) {
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            try (FileInputStream in = new FileInputStream(propertiesFile);){
                properties.load(in);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to update " + String.valueOf(propertiesFile), e);
            }
        }
        try (FileOutputStream out = new FileOutputStream(propertiesFile);){
            propertiesConsumer.accept(properties);
            properties.store(out, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update " + String.valueOf(propertiesFile), e);
        }
    }

    private File getQuarkusPropertiesFile() {
        return this.distPath.resolve("conf").resolve("quarkus.properties").toFile();
    }

    public Path getDistPath() {
        return this.distPath;
    }

    public void copyProvider(TestProvider provider) {
        File fileUri;
        URL pathUrl = provider.getClass().getResource(".");
        try {
            fileUri = new File(pathUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid package provider path", e);
        }
        Path providerPackagePath = Paths.get(fileUri.getPath(), new String[0]);
        JavaArchive providerJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(provider.getName() + ".jar"))).addClasses(provider.getClasses())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        Map<String, String> manifestResources = provider.getManifestResources();
        for (Map.Entry<String, String> resource : manifestResources.entrySet()) {
            try {
                providerJar.addAsManifestResource(providerPackagePath.resolve(resource.getKey()).toFile(), resource.getValue());
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to add manifest resource: " + resource.getKey(), cause);
            }
        }
        this.copyOrReplaceFile(providerPackagePath.resolve("quarkus.properties"), Path.of("conf", "quarkus.properties"));
        ((ZipExporter)providerJar.as(ZipExporter.class)).exportTo(this.getDistPath().resolve("providers").resolve(providerJar.getName()).toFile());
    }

    @Override
    public <D extends KeycloakDistribution> D unwrap(Class<D> type) {
        if (!KeycloakDistribution.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Not a " + String.valueOf(KeycloakDistribution.class) + " type");
        }
        if (type.isInstance(this)) {
            return (D)((KeycloakDistribution)type.cast(type));
        }
        throw new IllegalArgumentException("Not a " + String.valueOf(type) + " type");
    }

    @Override
    public void clearEnv() {
        this.envVars.clear();
    }

    private static final class DefaultOutputConsumer
    implements OutputConsumer {
        private final List<String> stdOut = Collections.synchronizedList(new ArrayList());
        private final List<String> errOut = Collections.synchronizedList(new ArrayList());

        private DefaultOutputConsumer() {
        }

        @Override
        public void onStdOut(String line) {
            System.out.println(line);
            this.stdOut.add(line);
        }

        @Override
        public void onErrOut(String line) {
            System.err.println(line);
            this.errOut.add(line);
        }

        @Override
        public void reset() {
            this.stdOut.clear();
            this.errOut.clear();
        }

        @Override
        public List<String> getErrOut() {
            return this.errOut;
        }

        @Override
        public List<String> getStdOut() {
            return this.stdOut;
        }
    }
}

