/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.util.Arrays;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.testcontainers.images.PullPolicy;

public class InfinispanContainer
extends org.infinispan.server.test.core.InfinispanContainer {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String PORT = System.getProperty("keycloak.externalInfinispan.port", "11222");
    public static final String USERNAME = System.getProperty("keycloak.externalInfinispan.username", "keycloak");
    public static final String PASSWORD = System.getProperty("keycloak.externalInfinispan.password", "Password1!");
    private static RemoteCacheManager remoteCacheManager;

    public InfinispanContainer() {
        super(InfinispanContainer.getImageName());
        this.withUser(USERNAME);
        this.withPassword(PASSWORD);
        this.getExposedPorts().forEach(i -> this.addFixedExposedPort((int)i, (int)i));
        if (InfinispanContainer.getImageName().startsWith("quay.io/infinispan-test")) {
            this.withImagePullPolicy(PullPolicy.alwaysPull());
        }
    }

    private static String getImageName() {
        String INFINISPAN_IMAGE = System.getProperty("kc.infinispan.container.image");
        if (INFINISPAN_IMAGE.matches("quay.io/infinispan/.*-SNAPSHOT")) {
            INFINISPAN_IMAGE = INFINISPAN_IMAGE.replaceAll("quay.io/infinispan/", "quay.io/infinispan-test/");
            INFINISPAN_IMAGE = INFINISPAN_IMAGE.replaceAll("[0-9]*-SNAPSHOT$", "x");
        }
        return INFINISPAN_IMAGE;
    }

    public static void removeCache(String cache) {
        remoteCacheManager.getCache(cache).stop();
        remoteCacheManager.administration().removeCache(cache);
    }

    private void establishHotRodConnection() {
        remoteCacheManager = this.getRemoteCacheManager();
    }

    public void start() {
        this.logger().info("Starting ISPN container");
        super.start();
        this.establishHotRodConnection();
        Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES).forEach(cacheName -> {
            this.LOG.infof("Creating cache '%s'", cacheName);
            this.createCache(remoteCacheManager, (String)cacheName);
        });
    }

    public void stop() {
        this.logger().info("Stopping ISPN container");
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        super.stop();
    }

    public void createCache(RemoteCacheManager remoteCacheManager, String cacheName) {
        String xml = String.format("<distributed-cache name=\"%s\" mode=\"SYNC\" owners=\"2\"></distributed-cache>", cacheName);
        remoteCacheManager.administration().getOrCreateCache(cacheName, (BasicConfiguration)new StringConfiguration(xml));
    }

    public String getPort() {
        return PORT;
    }

    public String getUsername() {
        return USERNAME;
    }

    public String getPassword() {
        return PASSWORD;
    }
}

