/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.it.junit5.extension.Storage;
import org.keycloak.it.junit5.extension.WithDatabase;

final class ServerOptions
extends ArrayList<String> {
    private static final Predicate<String> IGNORED_ARGUMENTS = ((Predicate<String>)s -> false).or("--optimized"::equals).or("export"::equals).or("import"::equals).or("--help"::equals).or("--help-all"::equals).or("-h"::equals).or("show-config"::equals);
    private boolean isBuildPhase = false;

    ServerOptions(Storage storageConfig, WithDatabase withDatabase, List<String> rawOptions) {
        if (rawOptions.isEmpty()) {
            return;
        }
        this.isBuildPhase = rawOptions.contains("build");
        for (Map.Entry<String, Predicate<String>> entry : this.getDefaultOptions(storageConfig, withDatabase).entrySet()) {
            if (this.contains(entry.getKey()) || rawOptions.stream().anyMatch(entry.getValue())) continue;
            this.add(entry.getKey());
        }
        this.addAll(0, rawOptions);
    }

    private Map<String, Predicate<String>> getDefaultOptions(Storage storageConfig, WithDatabase withDatabase) {
        HashMap<String, Predicate<String>> defaultOptions = new HashMap<String, Predicate<String>>();
        if (!this.isBuildPhase) {
            defaultOptions.put("--cache=local", this.ignoreCacheLocal(storageConfig));
        }
        return defaultOptions;
    }

    private Predicate<String> ignoreCacheLocal(final Storage storageConfig) {
        return new Predicate<String>(){

            @Override
            public boolean test(String arg) {
                return arg.contains("--cache") || storageConfig == null || !storageConfig.defaultLocalCache();
            }
        }.or(IGNORED_ARGUMENTS);
    }
}

