/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jaxrs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.BasicAuthRequestAuthenticator;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.jaxrs.JaxrsBearerTokenFilter;
import org.keycloak.jaxrs.JaxrsHttpFacade;
import org.keycloak.representations.AccessToken;

@PreMatching
@Priority(value=1000)
@Deprecated
public class JaxrsBearerTokenFilterImpl
implements JaxrsBearerTokenFilter {
    private static final Logger log = Logger.getLogger("" + JaxrsBearerTokenFilterImpl.class);
    private String keycloakConfigFile;
    private String keycloakConfigResolverClass;
    protected volatile boolean started;
    protected AdapterDeploymentContext deploymentContext;
    protected NodesRegistrationManagement nodesRegistrationManagement;
    protected UserSessionManagement userSessionManagement = new EmptyUserSessionManagement();

    public void setKeycloakConfigFile(String configFile) {
        this.keycloakConfigFile = configFile;
        this.attemptStart();
    }

    public String getKeycloakConfigFile() {
        return this.keycloakConfigFile;
    }

    public String getKeycloakConfigResolverClass() {
        return this.keycloakConfigResolverClass;
    }

    public void setKeycloakConfigResolverClass(String keycloakConfigResolverClass) {
        this.keycloakConfigResolverClass = keycloakConfigResolverClass;
        this.attemptStart();
    }

    protected void attemptStart() {
        if (this.started) {
            throw new IllegalStateException("Filter already started. Make sure to specify just keycloakConfigResolver or keycloakConfigFile but not both");
        }
        if (this.isInitialized()) {
            this.start();
        } else {
            log.fine("Not yet initialized");
        }
    }

    protected boolean isInitialized() {
        return this.keycloakConfigFile != null || this.keycloakConfigResolverClass != null;
    }

    protected void start() {
        if (this.started) {
            throw new IllegalStateException("Filter already started. Make sure to specify just keycloakConfigResolver or keycloakConfigFile but not both");
        }
        if (this.keycloakConfigResolverClass != null) {
            Class<? extends KeycloakConfigResolver> resolverClass = this.loadResolverClass();
            try {
                KeycloakConfigResolver resolver = resolverClass.newInstance();
                log.info("Using " + resolver + " to resolve Keycloak configuration on a per-request basis.");
                this.deploymentContext = new AdapterDeploymentContext(resolver);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate resolver " + resolverClass);
            }
        } else {
            if (this.keycloakConfigFile == null) {
                throw new IllegalArgumentException("You need to specify either keycloakConfigResolverClass or keycloakConfigFile in configuration");
            }
            InputStream is = this.loadKeycloakConfigFile();
            KeycloakDeployment kd = KeycloakDeploymentBuilder.build((InputStream)is);
            this.deploymentContext = new AdapterDeploymentContext(kd);
            log.info("Keycloak is using a per-deployment configuration loaded from: " + this.keycloakConfigFile);
        }
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
        this.started = true;
    }

    protected Class<? extends KeycloakConfigResolver> loadResolverClass() {
        try {
            return this.getClass().getClassLoader().loadClass(this.keycloakConfigResolverClass);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(this.keycloakConfigResolverClass);
            }
            catch (ClassNotFoundException cnfe2) {
                throw new RuntimeException("Unable to find resolver class: " + this.keycloakConfigResolverClass);
            }
        }
    }

    protected InputStream loadKeycloakConfigFile() {
        if (this.keycloakConfigFile.startsWith("classpath:")) {
            String classPathLocation = this.keycloakConfigFile.replace("classpath:", "");
            log.fine("Loading config from classpath on location: " + classPathLocation);
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(classPathLocation);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classPathLocation);
            }
            if (is != null) {
                return is;
            }
            throw new RuntimeException("Unable to find config from classpath: " + this.keycloakConfigFile);
        }
        try {
            log.fine("Loading config from file: " + this.keycloakConfigFile);
            return new FileInputStream(this.keycloakConfigFile);
        }
        catch (FileNotFoundException fnfe) {
            log.severe("Config not found on " + this.keycloakConfigFile);
            throw new RuntimeException(fnfe);
        }
    }

    public void filter(ContainerRequestContext request) throws IOException {
        SecurityContext securityContext = this.getRequestSecurityContext(request);
        JaxrsHttpFacade facade = new JaxrsHttpFacade(request, securityContext);
        if (this.handlePreauth(facade)) {
            return;
        }
        KeycloakDeployment resolvedDeployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        this.nodesRegistrationManagement.tryRegister(resolvedDeployment);
        this.bearerAuthentication(facade, request, resolvedDeployment);
    }

    protected boolean handlePreauth(JaxrsHttpFacade facade) {
        PreAuthActionsHandler handler = new PreAuthActionsHandler(this.userSessionManagement, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            if (!facade.isResponseFinished()) {
                facade.getResponse().end();
            }
            return true;
        }
        return false;
    }

    protected void bearerAuthentication(JaxrsHttpFacade facade, ContainerRequestContext request, KeycloakDeployment resolvedDeployment) {
        BearerTokenRequestAuthenticator authenticator = new BearerTokenRequestAuthenticator(resolvedDeployment);
        AuthOutcome outcome = authenticator.authenticate((HttpFacade)facade);
        if (outcome == AuthOutcome.NOT_ATTEMPTED && resolvedDeployment.isEnableBasicAuth()) {
            authenticator = new BasicAuthRequestAuthenticator(resolvedDeployment);
            outcome = authenticator.authenticate((HttpFacade)facade);
        }
        if (outcome == AuthOutcome.FAILED || outcome == AuthOutcome.NOT_ATTEMPTED) {
            AuthChallenge challenge = authenticator.getChallenge();
            log.fine("Authentication outcome: " + outcome);
            boolean challengeSent = challenge.challenge((HttpFacade)facade);
            if (!challengeSent) {
                facade.getResponse().setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            }
            if (!facade.isResponseFinished()) {
                facade.getResponse().end();
            }
            return;
        }
        if (this.verifySslFailed(facade, resolvedDeployment)) {
            return;
        }
        this.propagateSecurityContext(facade, request, resolvedDeployment, authenticator);
        this.handleAuthActions(facade, resolvedDeployment);
    }

    protected void propagateSecurityContext(JaxrsHttpFacade facade, ContainerRequestContext request, KeycloakDeployment resolvedDeployment, BearerTokenRequestAuthenticator bearer) {
        RefreshableKeycloakSecurityContext skSession = new RefreshableKeycloakSecurityContext(resolvedDeployment, null, bearer.getTokenString(), bearer.getToken(), null, null, null);
        facade.setSecurityContext((KeycloakSecurityContext)skSession);
        String principalName = AdapterUtils.getPrincipalName((KeycloakDeployment)resolvedDeployment, (AccessToken)bearer.getToken());
        final KeycloakPrincipal principal = new KeycloakPrincipal(principalName, (KeycloakSecurityContext)skSession);
        SecurityContext anonymousSecurityContext = this.getRequestSecurityContext(request);
        final boolean isSecure = anonymousSecurityContext.isSecure();
        final Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)skSession);
        SecurityContext ctx = new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return roles.contains(role);
            }

            public boolean isSecure() {
                return isSecure;
            }

            public String getAuthenticationScheme() {
                return "OAUTH_BEARER";
            }
        };
        request.setSecurityContext(ctx);
    }

    protected boolean verifySslFailed(JaxrsHttpFacade facade, KeycloakDeployment deployment) {
        if (!facade.getRequest().isSecure() && deployment.getSslRequired().isRequired(facade.getRequest().getRemoteAddr())) {
            log.warning("SSL is required to authenticate, but request is not secured");
            facade.getResponse().sendError(403, "SSL required!");
            return true;
        }
        return false;
    }

    protected SecurityContext getRequestSecurityContext(ContainerRequestContext request) {
        return request.getSecurityContext();
    }

    protected void handleAuthActions(JaxrsHttpFacade facade, KeycloakDeployment deployment) {
        AuthenticatedActionsHandler authActionsHandler = new AuthenticatedActionsHandler(deployment, (OIDCHttpFacade)facade);
        if (authActionsHandler.handledRequest() && !facade.isResponseFinished()) {
            facade.getResponse().end();
        }
    }

    private static class EmptyUserSessionManagement
    implements UserSessionManagement {
        private EmptyUserSessionManagement() {
        }

        public void logoutAll() {
        }

        public void logoutHttpSessions(List<String> ids) {
        }
    }
}

