/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;

public class CachedUser
implements Serializable {
    private String id;
    private String realm;
    private String username;
    private Long createdTimestamp;
    private String firstName;
    private String lastName;
    private String email;
    private boolean emailVerified;
    private List<UserCredentialValueModel> credentials = new LinkedList<UserCredentialValueModel>();
    private boolean enabled;
    private boolean totp;
    private String federationLink;
    private String serviceAccountClientLink;
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private Set<String> requiredActions = new HashSet<String>();
    private Set<String> roleMappings = new HashSet<String>();
    private Set<String> groups = new HashSet<String>();

    public CachedUser(RealmModel realm, UserModel user) {
        this.id = user.getId();
        this.realm = realm.getId();
        this.username = user.getUsername();
        this.createdTimestamp = user.getCreatedTimestamp();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.attributes.putAll(user.getAttributes());
        this.email = user.getEmail();
        this.emailVerified = user.isEmailVerified();
        this.credentials.addAll(user.getCredentialsDirectly());
        this.enabled = user.isEnabled();
        this.totp = user.isOtpEnabled();
        this.federationLink = user.getFederationLink();
        this.serviceAccountClientLink = user.getServiceAccountClientLink();
        this.requiredActions.addAll(user.getRequiredActions());
        for (RoleModel role : user.getRoleMappings()) {
            this.roleMappings.add(role.getId());
        }
        Set groupMappings = user.getGroups();
        if (groupMappings != null) {
            for (GroupModel group : groupMappings) {
                this.groups.add(group.getId());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public List<UserCredentialValueModel> getCredentials() {
        return this.credentials;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTotp() {
        return this.totp;
    }

    public MultivaluedHashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getRequiredActions() {
        return this.requiredActions;
    }

    public Set<String> getRoleMappings() {
        return this.roleMappings;
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public Set<String> getGroups() {
        return this.groups;
    }
}

