/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;

public abstract class ClientAdapter
implements ClientModel {
    protected CachedClient cachedClient;
    protected CacheRealmProvider cacheSession;
    protected ClientModel updatedClient;
    protected RealmModel cachedRealm;
    protected RealmCache cache;

    public ClientAdapter(RealmModel cachedRealm, CachedClient cached, RealmCache cache, CacheRealmProvider cacheSession) {
        this.cachedRealm = cachedRealm;
        this.cache = cache;
        this.cacheSession = cacheSession;
        this.cachedClient = cached;
    }

    protected abstract void getDelegateForUpdate();

    public String getId() {
        if (this.updatedClient != null) {
            return this.updatedClient.getId();
        }
        return this.cachedClient.getId();
    }

    public abstract String getClientId();

    public long getAllowedClaimsMask() {
        if (this.updatedClient != null) {
            return this.updatedClient.getAllowedClaimsMask();
        }
        return this.cachedClient.getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.getDelegateForUpdate();
        this.updatedClient.setAllowedClaimsMask(mask);
    }

    public Set<String> getWebOrigins() {
        if (this.updatedClient != null) {
            return this.updatedClient.getWebOrigins();
        }
        return this.cachedClient.getWebOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegateForUpdate();
        this.updatedClient.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updatedClient.addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updatedClient.removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        if (this.updatedClient != null) {
            return this.updatedClient.getRedirectUris();
        }
        return this.cachedClient.getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegateForUpdate();
        this.updatedClient.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updatedClient.addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updatedClient.removeRedirectUri(redirectUri);
    }

    public boolean isEnabled() {
        if (this.updatedClient != null) {
            return this.updatedClient.isEnabled();
        }
        return this.cachedClient.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updatedClient.setEnabled(enabled);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getSecret());
    }

    public String getSecret() {
        if (this.updatedClient != null) {
            return this.updatedClient.getSecret();
        }
        return this.cachedClient.getSecret();
    }

    public void setSecret(String secret) {
        this.getDelegateForUpdate();
        this.updatedClient.setSecret(secret);
    }

    public boolean isPublicClient() {
        if (this.updatedClient != null) {
            return this.updatedClient.isPublicClient();
        }
        return this.cachedClient.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getDelegateForUpdate();
        this.updatedClient.setPublicClient(flag);
    }

    public boolean isFullScopeAllowed() {
        if (this.updatedClient != null) {
            return this.updatedClient.isFullScopeAllowed();
        }
        return this.cachedClient.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getDelegateForUpdate();
        this.updatedClient.setFullScopeAllowed(value);
    }

    public boolean isDirectGrantsOnly() {
        if (this.updatedClient != null) {
            return this.updatedClient.isDirectGrantsOnly();
        }
        return this.cachedClient.isDirectGrantsOnly();
    }

    public void setDirectGrantsOnly(boolean flag) {
        this.getDelegateForUpdate();
        this.updatedClient.setDirectGrantsOnly(flag);
    }

    public Set<RoleModel> getScopeMappings() {
        if (this.updatedClient != null) {
            return this.updatedClient.getScopeMappings();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cachedClient.getScope()) {
            roles.add(this.cacheSession.getRoleById(id, this.getRealm()));
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updatedClient.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updatedClient.deleteScopeMapping(role);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.cachedRealm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.updatedClient != null) {
            return this.updatedClient.hasScope(role);
        }
        if (this.cachedClient.isFullScopeAllowed() || this.cachedClient.getScope().contains(role.getId())) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public int getNotBefore() {
        if (this.updatedClient != null) {
            return this.updatedClient.getNotBefore();
        }
        return this.cachedClient.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updatedClient.setNotBefore(notBefore);
    }

    public String getProtocol() {
        if (this.updatedClient != null) {
            return this.updatedClient.getProtocol();
        }
        return this.cachedClient.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegateForUpdate();
        this.updatedClient.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updatedClient.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updatedClient.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.updatedClient != null) {
            return this.updatedClient.getAttribute(name);
        }
        return this.cachedClient.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        if (this.updatedClient != null) {
            return this.updatedClient.getAttributes();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.cachedClient.getAttributes());
        return copy;
    }
}

