/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.models.cache.CacheUserProviderFactory;
import org.keycloak.models.cache.DefaultCacheUserProvider;
import org.keycloak.models.cache.MemoryUserCache;

public class MemoryCacheUserProviderFactory
implements CacheUserProviderFactory {
    protected MemoryUserCache cache;

    public CacheUserProvider create(KeycloakSession session) {
        return new DefaultCacheUserProvider(this.cache, session);
    }

    public void init(Config.Scope config) {
        config.get("");
        this.cache = new MemoryUserCache();
        int size = config.getInt("maxSize", Integer.valueOf(10000));
        this.cache.setMaxUserCacheSize(size);
    }

    public void close() {
    }

    public String getId() {
        return "mem";
    }
}

