/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.entities.CachedApplicationRole;
import org.keycloak.models.cache.entities.CachedRealmRole;
import org.keycloak.models.cache.entities.CachedRole;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel {
    protected RoleModel updated;
    protected CachedRole cached;
    protected KeycloakCache cache;
    protected CacheKeycloakSession cacheSession;
    protected RealmModel realm;

    public RoleAdapter(CachedRole cached, KeycloakCache cache, CacheKeycloakSession session, RealmModel realm) {
        this.cached = cached;
        this.cache = cache;
        this.cacheSession = session;
        this.realm = realm;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRoleInvalidation(this.getId());
            this.updated = this.cacheSession.getDelegate().getRoleById(this.getId(), this.realm);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public String getName() {
        if (this.updated != null) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public String getDescription() {
        if (this.updated != null) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public boolean isComposite() {
        if (this.updated != null) {
            return this.updated.isComposite();
        }
        return this.cached.isComposite();
    }

    public void addCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addCompositeRole(role);
    }

    public void removeCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.removeCompositeRole(role);
    }

    public Set<RoleModel> getComposites() {
        if (this.updated != null) {
            return this.updated.getComposites();
        }
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (String id : this.cached.getComposites()) {
            RoleModel role = this.realm.getRoleById(id);
            if (role == null) {
                throw new IllegalStateException("Could not find composite: " + id);
            }
            set.add(role);
        }
        return set;
    }

    public RoleContainerModel getContainer() {
        if (this.cached instanceof CachedRealmRole) {
            return this.realm;
        }
        CachedApplicationRole appRole = (CachedApplicationRole)this.cached;
        return this.realm.getApplicationById(appRole.getAppId());
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

