/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.cache.ApplicationAdapter;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.OAuthClientAdapter;
import org.keycloak.models.cache.RealmAdapter;
import org.keycloak.models.cache.RoleAdapter;
import org.keycloak.models.cache.entities.CachedApplication;
import org.keycloak.models.cache.entities.CachedApplicationRole;
import org.keycloak.models.cache.entities.CachedOAuthClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRealmRole;
import org.keycloak.models.cache.entities.CachedRole;
import org.keycloak.provider.ProviderSession;

public class DefaultCacheKeycloakSession
implements CacheKeycloakSession {
    protected KeycloakCache cache;
    protected ProviderSession providerSession;
    protected KeycloakSession sessionDelegate;
    protected KeycloakTransaction transactionDelegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Set<String> appInvalidations = new HashSet<String>();
    protected Set<String> roleInvalidations = new HashSet<String>();
    protected Set<String> clientInvalidations = new HashSet<String>();
    protected Map<String, RealmModel> managedRealms = new HashMap<String, RealmModel>();
    protected Map<String, ApplicationModel> managedApplications = new HashMap<String, ApplicationModel>();
    protected Map<String, OAuthClientModel> managedClients = new HashMap<String, OAuthClientModel>();
    protected Map<String, RoleModel> managedRoles = new HashMap<String, RoleModel>();
    protected boolean clearAll;

    public DefaultCacheKeycloakSession(KeycloakCache cache, ProviderSession providerSession) {
        this.cache = cache;
        this.providerSession = providerSession;
    }

    @Override
    public KeycloakSession getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.sessionDelegate != null) {
            return this.sessionDelegate;
        }
        this.sessionDelegate = (KeycloakSession)this.providerSession.getProvider(KeycloakSession.class);
        this.transactionDelegate = this.sessionDelegate.getTransaction();
        if (!this.transactionDelegate.isActive()) {
            this.transactionDelegate.begin();
            if (this.setRollbackOnly) {
                this.transactionDelegate.setRollbackOnly();
            }
        }
        return this.sessionDelegate;
    }

    @Override
    public void registerRealmInvalidation(String id) {
        this.realmInvalidations.add(id);
    }

    @Override
    public void registerApplicationInvalidation(String id) {
        this.appInvalidations.add(id);
    }

    @Override
    public void registerRoleInvalidation(String id) {
        this.roleInvalidations.add(id);
    }

    @Override
    public void registerOAuthClientInvalidation(String id) {
        this.clientInvalidations.add(id);
    }

    protected void runInvalidations() {
        for (String id : this.realmInvalidations) {
            this.cache.invalidateCachedRealmById(id);
        }
        for (String id : this.roleInvalidations) {
            this.cache.invalidateRoleById(id);
        }
        for (String id : this.appInvalidations) {
            this.cache.invalidateCachedApplicationById(id);
        }
        for (String id : this.clientInvalidations) {
            this.cache.invalidateCachedOAuthClientById(id);
        }
    }

    public KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                DefaultCacheKeycloakSession.this.transactionActive = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commit() {
                if (DefaultCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                try {
                    DefaultCacheKeycloakSession.this.sessionDelegate.getTransaction().commit();
                    if (DefaultCacheKeycloakSession.this.clearAll) {
                        DefaultCacheKeycloakSession.this.cache.clear();
                    }
                }
                finally {
                    DefaultCacheKeycloakSession.this.runInvalidations();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rollback() {
                DefaultCacheKeycloakSession.this.setRollbackOnly = true;
                if (DefaultCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                try {
                    DefaultCacheKeycloakSession.this.sessionDelegate.getTransaction().rollback();
                }
                finally {
                    DefaultCacheKeycloakSession.this.runInvalidations();
                }
            }

            public void setRollbackOnly() {
                DefaultCacheKeycloakSession.this.setRollbackOnly = true;
                if (DefaultCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                DefaultCacheKeycloakSession.this.sessionDelegate.getTransaction().setRollbackOnly();
                DefaultCacheKeycloakSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return DefaultCacheKeycloakSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return DefaultCacheKeycloakSession.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        RealmModel realm = this.getDelegate().createRealm(name);
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel createRealm(String id, String name) {
        RealmModel realm = this.getDelegate().createRealm(id, name);
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel getRealm(String id) {
        CachedRealm cached = this.cache.getCachedRealm(id);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealm(id);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedRealm(this.cache, this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(id)) {
                return this.getDelegate().getRealm(id);
            }
            if (this.managedRealms.containsKey(id)) {
                return this.managedRealms.get(id);
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(id, adapter);
        return adapter;
    }

    public RealmModel getRealmByName(String name) {
        CachedRealm cached = this.cache.getCachedRealmByName(name);
        if (cached == null) {
            RealmModel model = this.getDelegate().getRealmByName(name);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(model.getId())) {
                return model;
            }
            cached = new CachedRealm(this.cache, this, model);
            this.cache.addCachedRealm(cached);
        } else {
            if (this.realmInvalidations.contains(cached.getId())) {
                return this.getDelegate().getRealmByName(name);
            }
            if (this.managedRealms.containsKey(cached.getId())) {
                return this.managedRealms.get(cached.getId());
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(cached.getId(), adapter);
        return adapter;
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return this.getDelegate().getUserById(id, realm);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        return this.getDelegate().getUserByUsername(username, realm);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return this.getDelegate().getUserByEmail(email, realm);
    }

    public List<RealmModel> getRealms() {
        return this.getDelegate().getRealms();
    }

    public boolean removeRealm(String id) {
        this.cache.invalidateCachedRealmById(id);
        boolean didIt = this.getDelegate().removeRealm(id);
        this.realmInvalidations.add(id);
        return didIt;
    }

    public void removeAllData() {
        this.cache.clear();
        this.getDelegate().removeAllData();
        this.clearAll = true;
    }

    public void close() {
        if (this.sessionDelegate != null) {
            this.sessionDelegate.close();
        }
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        return this.getDelegate().getUserBySocialLink(socialLink, realm);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getDelegate().getUsers(realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        return this.getDelegate().getSocialLinks(user, realm);
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        return this.getDelegate().getSocialLink(user, socialProvider, realm);
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        CachedRole cached = this.cache.getRole(id);
        if (cached == null) {
            RoleModel model = this.getDelegate().getRoleById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.roleInvalidations.contains(id)) {
                return model;
            }
            cached = model.getContainer() instanceof ApplicationModel ? new CachedApplicationRole(((ApplicationModel)model.getContainer()).getId(), model) : new CachedRealmRole(model);
            this.cache.addCachedRole(cached);
        } else {
            if (this.roleInvalidations.contains(id)) {
                return this.getDelegate().getRoleById(id, realm);
            }
            if (this.managedRoles.containsKey(id)) {
                return this.managedRoles.get(id);
            }
        }
        RoleAdapter adapter = new RoleAdapter(cached, this.cache, this, realm);
        this.managedRoles.put(id, adapter);
        return adapter;
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        CachedApplication cached = this.cache.getApplication(id);
        if (cached == null) {
            ApplicationModel model = this.getDelegate().getApplicationById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.appInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedApplication(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedApplication(cached);
        } else {
            if (this.appInvalidations.contains(id)) {
                return this.getDelegate().getApplicationById(id, realm);
            }
            if (this.managedApplications.containsKey(id)) {
                return this.managedApplications.get(id);
            }
        }
        ApplicationAdapter adapter = new ApplicationAdapter(realm, cached, this, this.cache);
        this.managedApplications.put(id, adapter);
        return adapter;
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        CachedOAuthClient cached = this.cache.getOAuthClient(id);
        if (cached == null) {
            OAuthClientModel model = this.getDelegate().getOAuthClientById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.clientInvalidations.contains(id)) {
                return model;
            }
            cached = new CachedOAuthClient(this.cache, this.getDelegate(), realm, model);
            this.cache.addCachedOAuthClient(cached);
        } else {
            if (this.clientInvalidations.contains(id)) {
                return this.getDelegate().getOAuthClientById(id, realm);
            }
            if (this.managedClients.containsKey(id)) {
                return this.managedClients.get(id);
            }
        }
        OAuthClientAdapter adapter = new OAuthClientAdapter(realm, cached, this, this.cache);
        this.managedClients.put(id, adapter);
        return adapter;
    }

    public UsernameLoginFailureModel getUserLoginFailure(String username, RealmModel realm) {
        return this.getDelegate().getUserLoginFailure(username, realm);
    }

    public UsernameLoginFailureModel addUserLoginFailure(String username, RealmModel realm) {
        return this.getDelegate().addUserLoginFailure(username, realm);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        return this.getDelegate().getAllUserLoginFailures(realm);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String ipAddress) {
        return this.getDelegate().createUserSession(realm, user, ipAddress);
    }

    public UserSessionModel getUserSession(String id, RealmModel realm) {
        return this.getDelegate().getUserSession(id, realm);
    }

    public List<UserSessionModel> getUserSessions(UserModel user, RealmModel realm) {
        return this.getDelegate().getUserSessions(user, realm);
    }

    public Set<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getDelegate().getUserSessions(realm, client);
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getDelegate().getActiveUserSessions(realm, client);
    }

    public void removeUserSession(UserSessionModel session) {
        this.getDelegate().removeUserSession(session);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.getDelegate().removeUserSessions(realm, user);
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        this.getDelegate().removeExpiredUserSessions(realm);
    }

    public void removeUserSessions(RealmModel realm) {
        this.getDelegate().removeUserSessions(realm);
    }
}

