/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheRealmProviderFactory;
import org.keycloak.models.cache.infinispan.DefaultCacheRealmProvider;
import org.keycloak.models.cache.infinispan.InfinispanRealmCache;

public class InfinispanCacheRealmProviderFactory
implements CacheRealmProviderFactory {
    protected final ConcurrentHashMap<String, String> realmLookup = new ConcurrentHashMap();

    public CacheRealmProvider create(KeycloakSession session) {
        Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realms");
        InfinispanRealmCache realmCache = new InfinispanRealmCache((Cache<String, Object>)cache, this.realmLookup);
        return new DefaultCacheRealmProvider(realmCache, session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

