/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.keycloak.OAuthErrorException;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class KeycloakInstalled {
    private static final String KEYCLOAK_JSON = "META-INF/keycloak.json";
    private KeycloakDeployment deployment;
    private String tokenString;
    private String idTokenString;
    private IDToken idToken;
    private AccessToken token;
    private String refreshToken;
    private Status status;

    public KeycloakInstalled() {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_JSON);
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public KeycloakInstalled(InputStream config) {
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public void login() throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual();
        }
    }

    public void login(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual(printer, reader);
        }
    }

    public void logout() throws IOException, InterruptedException, URISyntaxException {
        if (this.status == Status.LOGGED_DESKTOP) {
            this.logoutDesktop();
        }
        this.tokenString = null;
        this.token = null;
        this.idTokenString = null;
        this.idToken = null;
        this.refreshToken = null;
        this.status = null;
    }

    public void loginDesktop() throws IOException, VerificationException, OAuthErrorException, URISyntaxException, ServerRequest.HttpFailure, InterruptedException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = "http://localhost:" + callback.server.getLocalPort();
        String state = UUID.randomUUID().toString();
        String authUrl = this.deployment.getAuthUrl().clone().queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).build(new Object[0]).toString();
        Desktop.getDesktop().browse(new URI(authUrl));
        callback.join();
        if (!state.equals(callback.state)) {
            throw new VerificationException("Invalid state");
        }
        if (callback.error != null) {
            throw new OAuthErrorException(callback.error, callback.errorDescription);
        }
        if (callback.errorException != null) {
            throw callback.errorException;
        }
        this.processCode(callback.code, redirectUri);
        this.status = Status.LOGGED_DESKTOP;
    }

    private void logoutDesktop() throws IOException, URISyntaxException, InterruptedException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = "http://localhost:" + callback.server.getLocalPort();
        String logoutUrl = this.deployment.getLogoutUrl().queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
        Desktop.getDesktop().browse(new URI(logoutUrl));
        callback.join();
        if (callback.errorException != null) {
            throw callback.errorException;
        }
    }

    public void loginManual() throws IOException, ServerRequest.HttpFailure, VerificationException {
        this.loginManual(System.out, new InputStreamReader(System.in));
    }

    public void loginManual(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        String authUrl = this.deployment.getAuthUrl().clone().queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
        printer.println("Open the following URL in a browser. After login copy/paste the code back and press <enter>");
        printer.println(authUrl);
        printer.println();
        printer.print("Code: ");
        String code = this.readCode(reader);
        this.processCode(code, redirectUri);
        this.status = Status.LOGGED_MANUAL;
    }

    public String getTokenString() throws VerificationException, IOException, ServerRequest.HttpFailure {
        return this.tokenString;
    }

    public String getTokenString(long minValidity, TimeUnit unit) throws VerificationException, IOException, ServerRequest.HttpFailure {
        long expires = (long)(this.token.getExpiration() * 1000) - unit.toMillis(minValidity);
        if (expires < System.currentTimeMillis()) {
            this.refreshToken();
        }
        return this.tokenString;
    }

    public void refreshToken() throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)this.refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    private void parseAccessToken(AccessTokenResponse tokenResponse) throws VerificationException {
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (PublicKey)this.deployment.getRealmKey(), (String)this.deployment.getRealm());
        if (this.idTokenString != null) {
            JWSInput input = new JWSInput(this.idTokenString);
            try {
                this.idToken = (IDToken)input.readJsonContent(IDToken.class);
            }
            catch (IOException e) {
                throw new VerificationException();
            }
        }
    }

    public AccessToken getToken() {
        return this.token;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isDesktopSupported() {
        return Desktop.isDesktopSupported();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private void processCode(String code, String redirectUri) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)this.deployment, (String)code, (String)redirectUri);
        this.parseAccessToken(tokenResponse);
    }

    private String readCode(Reader reader) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != ' ' && c != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    public class CallbackListener
    extends Thread {
        private ServerSocket server = new ServerSocket(0);
        private String code;
        private String error;
        private String errorDescription;
        private IOException errorException;
        private String state;

        @Override
        public void run() {
            try {
                Socket socket = this.server.accept();
                BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String request = br.readLine();
                String url = request.split(" ")[1];
                if (url.indexOf(63) >= 0) {
                    String[] params;
                    url = url.split("\\?")[1];
                    for (String param : params = url.split("&")) {
                        String[] p = param.split("=");
                        if (p[0].equals("code")) {
                            this.code = p[1];
                            continue;
                        }
                        if (p[0].equals("error")) {
                            this.error = p[1];
                            continue;
                        }
                        if (p[0].equals("error-description")) {
                            this.errorDescription = p[1];
                            continue;
                        }
                        if (!p[0].equals("state")) continue;
                        this.state = p[1];
                    }
                }
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                pw.println("Please close window and return to application");
                pw.flush();
                socket.close();
            }
            catch (IOException e) {
                this.errorException = e;
            }
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum Status {
        LOGGED_MANUAL,
        LOGGED_DESKTOP;

    }
}

