/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.guides.maven.Guide;

public class GuideParser {
    private final Pattern TEMPLATE_IMPORT_PATTERN = Pattern.compile("<#import \"/templates/guide.adoc\" as (?<importName>[^ ]*)>");
    private final Pattern GUIDE_ELEMENT_PATTERN = Pattern.compile("(?<key>priority|title|summary|tileVisible)=(\\\"(?<valueString>[^\\\"]*)\\\"|(?<valueInt>[\\d]*))");

    public Guide parse(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String importName = this.getImportName(br);
            String importElement = this.getGuideElement(br, importName);
            if (importElement != null) {
                Guide guide = new Guide();
                guide.setTemplate(file.getName());
                guide.setId(file.getName().replaceAll(".adoc", ""));
                this.setAttributes(importElement, guide);
                Guide guide2 = guide;
                return guide2;
            }
            Guide guide = null;
            return guide;
        }
    }

    private String getImportName(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line != null) {
            Matcher templateImportMatcher = this.TEMPLATE_IMPORT_PATTERN.matcher(line);
            if (templateImportMatcher.matches()) {
                return templateImportMatcher.group("importName");
            }
            line = br.readLine();
        }
        return null;
    }

    private String getGuideElement(BufferedReader br, String importName) throws IOException {
        if (importName != null) {
            String line = br.readLine();
            while (line != null) {
                if (line.contains("<@" + importName + ".guide")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(line.trim());
                    while (!line.contains(">")) {
                        line = br.readLine();
                        sb.append(" " + line.trim());
                    }
                    return sb.toString();
                }
                line = br.readLine();
            }
        }
        return null;
    }

    private void setAttributes(String importElement, Guide guide) {
        Matcher attributeMatcher = this.GUIDE_ELEMENT_PATTERN.matcher(importElement);
        while (attributeMatcher.find()) {
            String key;
            switch (key = attributeMatcher.group("key")) {
                case "title": {
                    guide.setTitle(attributeMatcher.group("valueString"));
                    break;
                }
                case "summary": {
                    guide.setSummary(attributeMatcher.group("valueString"));
                    break;
                }
                case "priority": {
                    guide.setPriority(Integer.parseInt(attributeMatcher.group("valueInt")));
                }
                case "tileVisible": {
                    guide.setTileVisible(Boolean.parseBoolean(attributeMatcher.group("valueString")));
                }
            }
        }
    }
}

