/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.guides.maven;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.keycloak.common.Version;
import org.keycloak.guides.maven.Context;
import org.keycloak.guides.maven.FreeMarker;

public class GuideBuilder {
    private final FreeMarker freeMarker;
    private final File srcDir;
    private final File targetDir;
    private final Log log;

    public GuideBuilder(File srcDir, File targetDir, Log log, Properties properties) throws IOException {
        this.srcDir = srcDir;
        this.targetDir = targetDir;
        this.log = log;
        HashMap<String, Object> globalAttributes = new HashMap<String, Object>();
        globalAttributes.put("ctx", new Context(srcDir));
        globalAttributes.put("version", Version.VERSION);
        globalAttributes.put("properties", properties);
        this.freeMarker = new FreeMarker(srcDir.getParentFile(), globalAttributes);
    }

    public void build() throws TemplateException, IOException {
        if (!this.srcDir.isDirectory() && !this.srcDir.mkdir()) {
            throw new RuntimeException("Can't create folder " + String.valueOf(this.srcDir));
        }
        for (String t : this.srcDir.list((dir, name) -> name.endsWith(".adoc"))) {
            this.freeMarker.template(this.srcDir.getName() + "/" + t, this.targetDir.getParentFile());
            if (this.log == null) continue;
            this.log.info((CharSequence)("Templated: " + this.srcDir.getName() + "/" + t));
        }
        File templatesDir = new File(this.srcDir, "templates");
        if (templatesDir.isDirectory()) {
            for (String t : templatesDir.list((dir, name) -> name.endsWith(".adoc"))) {
                this.freeMarker.template(this.srcDir.getName() + "/" + templatesDir.getName() + "/" + t, this.targetDir.getParentFile());
                if (this.log == null) continue;
                this.log.info((CharSequence)("Templated: " + templatesDir.getName() + "/" + t));
            }
        }
    }
}

