/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.theme.ClassLoaderTheme;

public class DefaultKeycloakThemeProvider
implements ThemeProvider {
    public static final String BASE = "base";
    public static final String PATTERNFLY = "patternfly";
    public static final String KEYCLOAK = "keycloak";
    private static Set<String> ACCOUNT_THEMES = new HashSet<String>();
    private static Set<String> LOGIN_THEMES = new HashSet<String>();
    private static Set<String> ADMIN_THEMES = new HashSet<String>();
    private static Set<String> EMAIL_THEMES = new HashSet<String>();
    private static Set<String> WELCOME_THEMES = new HashSet<String>();
    private static Set<String> COMMON_THEMES = new HashSet<String>();

    public int getProviderPriority() {
        return 0;
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        if (this.hasTheme(name, type)) {
            return new ClassLoaderTheme(name, type, this.getClass().getClassLoader());
        }
        return null;
    }

    public Set<String> nameSet(Theme.Type type) {
        switch (type) {
            case LOGIN: {
                return LOGIN_THEMES;
            }
            case ACCOUNT: {
                return ACCOUNT_THEMES;
            }
            case ADMIN: {
                return ADMIN_THEMES;
            }
            case EMAIL: {
                return EMAIL_THEMES;
            }
            case WELCOME: {
                return WELCOME_THEMES;
            }
            case COMMON: {
                return COMMON_THEMES;
            }
        }
        return Collections.emptySet();
    }

    public boolean hasTheme(String name, Theme.Type type) {
        return this.nameSet(type).contains(name);
    }

    public void close() {
    }

    static {
        Collections.addAll(ACCOUNT_THEMES, BASE, PATTERNFLY, KEYCLOAK);
        Collections.addAll(LOGIN_THEMES, BASE, PATTERNFLY, KEYCLOAK);
        Collections.addAll(ADMIN_THEMES, BASE, PATTERNFLY, KEYCLOAK);
        Collections.addAll(EMAIL_THEMES, KEYCLOAK);
        Collections.addAll(WELCOME_THEMES, KEYCLOAK);
        Collections.addAll(COMMON_THEMES, KEYCLOAK);
    }
}

