/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.theme.ClassLoaderTheme;

public class DefaultLoginThemeProvider
implements ThemeProvider {
    public static final String BASE = "base";
    public static final String PATTERNFLY = "patternfly";
    public static final String KEYCLOAK = "keycloak";
    private static Set<String> defaultThemes = new HashSet<String>();

    public int getProviderPriority() {
        return 0;
    }

    public Theme createTheme(String name, Theme.Type type) throws IOException {
        if (this.hasTheme(name, type)) {
            return new ClassLoaderTheme(name, type, this.getClass().getClassLoader());
        }
        return null;
    }

    public Set<String> nameSet(Theme.Type type) {
        if (type == Theme.Type.LOGIN || type == Theme.Type.ACCOUNT) {
            return defaultThemes;
        }
        return Collections.emptySet();
    }

    public boolean hasTheme(String name, Theme.Type type) {
        return this.nameSet(type).contains(name);
    }

    static {
        defaultThemes.add(BASE);
        defaultThemes.add(PATTERNFLY);
        defaultThemes.add(KEYCLOAK);
    }
}

