/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class LocaleHelper {
    public static final String LOCALE_COOKIE = "KEYCLOAK_LOCALE";
    public static final String UI_LOCALES_PARAM = "ui_locales";
    public static final String KC_LOCALE_PARAM = "kc_locale";

    public static Locale getLocale(RealmModel realm, UserModel user) {
        return LocaleHelper.getLocale(realm, user, null, null);
    }

    public static Locale getLocale(RealmModel realm, UserModel user, UriInfo uriInfo, HttpHeaders httpHeaders) {
        Locale locale;
        String localeString;
        if (!realm.isInternationalizationEnabled()) {
            return Locale.ENGLISH;
        }
        if (uriInfo != null && uriInfo.getQueryParameters().containsKey((Object)KC_LOCALE_PARAM)) {
            localeString = (String)uriInfo.getQueryParameters().getFirst((Object)KC_LOCALE_PARAM);
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                if (user != null) {
                    user.setSingleAttribute("locale", locale.toLanguageTag());
                }
                return locale;
            }
        }
        if (httpHeaders != null && httpHeaders.getCookies().containsKey(LOCALE_COOKIE)) {
            localeString = ((Cookie)httpHeaders.getCookies().get(LOCALE_COOKIE)).getValue();
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                if (user != null && user.getFirstAttribute("locale") == null) {
                    user.setSingleAttribute("locale", locale.toLanguageTag());
                }
                return locale;
            }
        }
        if (user != null && user.getAttributes().containsKey("locale")) {
            localeString = user.getFirstAttribute("locale");
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                return locale;
            }
        }
        if (uriInfo != null && uriInfo.getQueryParameters().containsKey((Object)UI_LOCALES_PARAM)) {
            localeString = (String)uriInfo.getQueryParameters().getFirst((Object)UI_LOCALES_PARAM);
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString.split(" "));
            if (locale != null) {
                return locale;
            }
        }
        if (httpHeaders != null && httpHeaders.getAcceptableLanguages() != null && !httpHeaders.getAcceptableLanguages().isEmpty()) {
            for (Locale l : httpHeaders.getAcceptableLanguages()) {
                String localeString2 = l.toLanguageTag();
                Locale locale2 = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString2);
                if (locale2 == null) continue;
                return locale2;
            }
        }
        if (realm.getDefaultLocale() != null) {
            return Locale.forLanguageTag(realm.getDefaultLocale());
        }
        return Locale.ENGLISH;
    }

    public static void updateLocaleCookie(Response.ResponseBuilder builder, Locale locale, RealmModel realm, UriInfo uriInfo, String path) {
        if (locale == null) {
            return;
        }
        boolean secure = realm.getSslRequired().isRequired(uriInfo.getRequestUri().getHost());
        builder.cookie(new NewCookie[]{new NewCookie(LOCALE_COOKIE, locale.toLanguageTag(), path, null, null, 31536000, secure)});
    }

    public static Locale findLocale(Set<String> supportedLocales, String ... localeStrings) {
        for (String localeString : localeStrings) {
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (String languageTag : supportedLocales) {
                Locale locale = Locale.forLanguageTag(languageTag);
                if (!locale.getLanguage().equals(search.getLanguage())) continue;
                if (locale.getCountry().equals("") && result == null) {
                    result = locale;
                }
                if (!locale.getCountry().equals(search.getCountry())) continue;
                return locale;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

