/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.iharder.Base64;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ExportUtils {
    public static RealmRepresentation exportRealm(KeycloakSession session, RealmModel realm, boolean includeUsers) {
        RealmRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)realm);
        rep.setAuditEnabled(realm.isAuditEnabled());
        if (realm.getAuditExpiration() != 0L) {
            rep.setAuditExpiration(realm.getAuditExpiration());
        }
        if (realm.getAuditListeners() != null) {
            rep.setAuditListeners(new LinkedList(realm.getAuditListeners()));
        }
        List applications = realm.getApplications();
        ArrayList<ApplicationRepresentation> appReps = new ArrayList<ApplicationRepresentation>();
        for (ApplicationModel app : applications) {
            ApplicationRepresentation appRep = ExportUtils.exportApplication(app);
            appReps.add(appRep);
        }
        rep.setApplications(appReps);
        List oauthClients = realm.getOAuthClients();
        ArrayList<OAuthClientRepresentation> oauthClientReps = new ArrayList<OAuthClientRepresentation>();
        for (OAuthClientModel oauthClient : oauthClients) {
            OAuthClientRepresentation clientRep = ModelToRepresentation.toRepresentation((OAuthClientModel)oauthClient);
            oauthClientReps.add(clientRep);
        }
        rep.setOauthClients(oauthClientReps);
        List<RoleRepresentation> realmRoleReps = null;
        HashMap<String, List<RoleRepresentation>> appRolesReps = new HashMap<String, List<RoleRepresentation>>();
        Set realmRoles = realm.getRoles();
        if (realmRoles != null && realmRoles.size() > 0) {
            realmRoleReps = ExportUtils.exportRoles(realmRoles);
        }
        for (ApplicationModel app : applications) {
            Set currentAppRoles = app.getRoles();
            List<RoleRepresentation> currentAppRoleReps = ExportUtils.exportRoles(currentAppRoles);
            appRolesReps.put(app.getName(), currentAppRoleReps);
        }
        RolesRepresentation rolesRep = new RolesRepresentation();
        if (realmRoleReps != null) {
            rolesRep.setRealm(realmRoleReps);
        }
        if (appRolesReps.size() > 0) {
            rolesRep.setApplication(appRolesReps);
        }
        rep.setRoles(rolesRep);
        ArrayList allClients = new ArrayList(applications);
        allClients.addAll(realm.getOAuthClients());
        HashMap appScopeReps = new HashMap();
        for (ClientModel client : allClients) {
            Set clientScopes = client.getScopeMappings();
            ScopeMappingRepresentation scopeMappingRep = null;
            for (RoleModel scope : clientScopes) {
                if (scope.getContainer() instanceof RealmModel) {
                    if (scopeMappingRep == null) {
                        scopeMappingRep = rep.scopeMapping(client.getClientId());
                    }
                    scopeMappingRep.role(scope.getName());
                    continue;
                }
                ApplicationModel app = (ApplicationModel)scope.getContainer();
                String appName = app.getName();
                ArrayList<ScopeMappingRepresentation> currentAppScopes = (ArrayList<ScopeMappingRepresentation>)appScopeReps.get(appName);
                if (currentAppScopes == null) {
                    currentAppScopes = new ArrayList<ScopeMappingRepresentation>();
                    appScopeReps.put(appName, currentAppScopes);
                }
                ScopeMappingRepresentation currentClientScope = null;
                for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                    if (!scopeMapping.getClient().equals(client.getClientId())) continue;
                    currentClientScope = scopeMapping;
                    break;
                }
                if (currentClientScope == null) {
                    currentClientScope = new ScopeMappingRepresentation();
                    currentClientScope.setClient(client.getClientId());
                    currentAppScopes.add(currentClientScope);
                }
                currentClientScope.role(scope.getName());
            }
        }
        if (appScopeReps.size() > 0) {
            rep.setApplicationScopeMappings(appScopeReps);
        }
        if (includeUsers) {
            List allUsers = session.users().getUsers(realm);
            ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
            for (UserModel user : allUsers) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                users.add(userRep);
            }
            if (users.size() > 0) {
                rep.setUsers(users);
            }
        }
        return rep;
    }

    public static ApplicationRepresentation exportApplication(ApplicationModel app) {
        ApplicationRepresentation appRep = ModelToRepresentation.toRepresentation((ApplicationModel)app);
        appRep.setSecret(app.getSecret());
        ClaimRepresentation claimRep = ModelToRepresentation.toRepresentation((ClientModel)app);
        appRep.setClaims(claimRep);
        return appRep;
    }

    public static List<RoleRepresentation> exportRoles(Collection<RoleModel> roles) {
        ArrayList<RoleRepresentation> roleReps = new ArrayList<RoleRepresentation>();
        for (RoleModel role : roles) {
            RoleRepresentation roleRep = ExportUtils.exportRole(role);
            roleReps.add(roleRep);
        }
        return roleReps;
    }

    public static List<String> getRoleNames(Collection<RoleModel> roles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (RoleModel role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public static RoleRepresentation exportRole(RoleModel role) {
        RoleRepresentation roleRep = ModelToRepresentation.toRepresentation((RoleModel)role);
        Set composites = role.getComposites();
        if (composites != null && composites.size() > 0) {
            HashSet<String> compositeRealmRoles = null;
            HashMap<String, ArrayList<String>> compositeAppRoles = null;
            for (RoleModel composite : composites) {
                ApplicationModel app;
                String appName;
                ArrayList<String> currentAppComposites;
                RoleContainerModel crContainer = composite.getContainer();
                if (crContainer instanceof RealmModel) {
                    if (compositeRealmRoles == null) {
                        compositeRealmRoles = new HashSet<String>();
                    }
                    compositeRealmRoles.add(composite.getName());
                    continue;
                }
                if (compositeAppRoles == null) {
                    compositeAppRoles = new HashMap<String, ArrayList<String>>();
                }
                if ((currentAppComposites = (ArrayList<String>)compositeAppRoles.get(appName = (app = (ApplicationModel)crContainer).getName())) == null) {
                    currentAppComposites = new ArrayList<String>();
                    compositeAppRoles.put(appName, currentAppComposites);
                }
                currentAppComposites.add(composite.getName());
            }
            RoleRepresentation.Composites compRep = new RoleRepresentation.Composites();
            if (compositeRealmRoles != null) {
                compRep.setRealm(compositeRealmRoles);
            }
            if (compositeAppRoles != null) {
                compRep.setApplication(compositeAppRoles);
            }
            roleRep.setComposites(compRep);
        }
        return roleRep;
    }

    public static UserRepresentation exportUser(KeycloakSession session, RealmModel realm, UserModel user) {
        UserRepresentation userRep = ModelToRepresentation.toRepresentation((UserModel)user);
        Set socialLinks = session.users().getSocialLinks(user, realm);
        ArrayList<SocialLinkRepresentation> socialLinkReps = new ArrayList<SocialLinkRepresentation>();
        for (SocialLinkModel socialLink : socialLinks) {
            SocialLinkRepresentation socialLinkRep = ExportUtils.exportSocialLink(socialLink);
            socialLinkReps.add(socialLinkRep);
        }
        if (socialLinkReps.size() > 0) {
            userRep.setSocialLinks(socialLinkReps);
        }
        Set roles = user.getRoleMappings();
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, ArrayList<String>> appRoleNames = new HashMap<String, ArrayList<String>>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ApplicationModel app = (ApplicationModel)role.getContainer();
            String appName = app.getName();
            ArrayList<String> currentAppRoles = (ArrayList<String>)appRoleNames.get(appName);
            if (currentAppRoles == null) {
                currentAppRoles = new ArrayList<String>();
                appRoleNames.put(appName, currentAppRoles);
            }
            currentAppRoles.add(role.getName());
        }
        if (realmRoleNames.size() > 0) {
            userRep.setRealmRoles(realmRoleNames);
        }
        if (appRoleNames.size() > 0) {
            userRep.setApplicationRoles(appRoleNames);
        }
        List creds = user.getCredentialsDirectly();
        ArrayList<CredentialRepresentation> credReps = new ArrayList<CredentialRepresentation>();
        for (UserCredentialValueModel cred : creds) {
            CredentialRepresentation credRep = ExportUtils.exportCredential(cred);
            credReps.add(credRep);
        }
        userRep.setCredentials(credReps);
        userRep.setFederationLink(user.getFederationLink());
        return userRep;
    }

    public static SocialLinkRepresentation exportSocialLink(SocialLinkModel socialLink) {
        SocialLinkRepresentation socialLinkRep = new SocialLinkRepresentation();
        socialLinkRep.setSocialProvider(socialLink.getSocialProvider());
        socialLinkRep.setSocialUserId(socialLink.getSocialUserId());
        socialLinkRep.setSocialUsername(socialLink.getSocialUsername());
        return socialLinkRep;
    }

    public static CredentialRepresentation exportCredential(UserCredentialValueModel userCred) {
        CredentialRepresentation credRep = new CredentialRepresentation();
        credRep.setType(userCred.getType());
        credRep.setDevice(userCred.getDevice());
        credRep.setHashedSaltedValue(userCred.getValue());
        credRep.setSalt(Base64.encodeBytes((byte[])userCred.getSalt()));
        credRep.setHashIterations(Integer.valueOf(userCred.getHashIterations()));
        return credRep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportUsersToStream(KeycloakSession session, RealmModel realm, List<UserModel> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        JsonFactory factory = mapper.getJsonFactory();
        JsonGenerator generator = factory.createJsonGenerator(os, JsonEncoding.UTF8);
        try {
            if (mapper.isEnabled(SerializationConfig.Feature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("users");
            generator.writeStartArray();
            for (UserModel user : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
    }
}

