/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import org.keycloak.exportimport.util.ExportImportJob;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;

public class ExportImportUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJobInTransaction(KeycloakSessionFactory factory, ExportImportJob job) throws IOException {
        KeycloakSession session = factory.create();
        KeycloakTransactionManager tx = session.getTransaction();
        try {
            tx.begin();
            job.run(session);
            if (tx.isActive()) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            session.close();
        }
    }

    public static String getMasterRealmAdminApplicationName(RealmModel realm) {
        return realm.getName() + "-realm";
    }
}

