/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.log;

import java.util.Map;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.productivity.java.syslog4j.SyslogIF;

public class SysLoggingEventListenerProvider
implements EventListenerProvider {
    private final SyslogIF syslogger;

    public SysLoggingEventListenerProvider(SyslogIF syslogger) {
        this.syslogger = syslogger;
    }

    public void onEvent(Event event) {
        int level = event.getError() != null ? 3 : 6;
        StringBuilder sb = new StringBuilder();
        sb.append("type=");
        sb.append(event.getType());
        sb.append(", realmId=");
        sb.append(event.getRealmId());
        sb.append(", clientId=");
        sb.append(event.getClientId());
        sb.append(", userId=");
        sb.append(event.getUserId());
        sb.append(", ipAddress=");
        sb.append(event.getIpAddress());
        if (event.getError() != null) {
            sb.append(", error=");
            sb.append(event.getError());
        }
        if (event.getDetails() != null) {
            for (Map.Entry e : event.getDetails().entrySet()) {
                sb.append(", ");
                sb.append((String)e.getKey());
                if (e.getValue() == null || ((String)e.getValue()).indexOf(32) == -1) {
                    sb.append("=");
                    sb.append((String)e.getValue());
                    continue;
                }
                sb.append("='");
                sb.append((String)e.getValue());
                sb.append("'");
            }
        }
        this.syslogger.log(level, sb.toString());
    }

    public void onEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        int level = adminEvent.getError() != null ? 3 : 6;
        StringBuilder sb = new StringBuilder();
        sb.append("operationType=");
        sb.append(adminEvent.getOperationType());
        sb.append(", realmId=");
        sb.append(adminEvent.getAuthDetails().getRealmId());
        sb.append(", clientId=");
        sb.append(adminEvent.getAuthDetails().getClientId());
        sb.append(", userId=");
        sb.append(adminEvent.getAuthDetails().getUserId());
        sb.append(", ipAddress=");
        sb.append(adminEvent.getAuthDetails().getIpAddress());
        sb.append(", resourcePath=");
        sb.append(adminEvent.getResourcePath());
        if (adminEvent.getError() != null) {
            sb.append(", error=");
            sb.append(adminEvent.getError());
        }
        this.syslogger.log(level, sb.toString());
    }

    public void close() {
    }
}

