/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.as7;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.keycloak.subsystem.server.as7.KeycloakAdapterConfigService;
import org.keycloak.subsystem.server.as7.KeycloakServerDeploymentProcessor;
import org.keycloak.subsystem.server.as7.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.server.as7.ServerUtil;

class KeycloakSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final KeycloakSubsystemAdd INSTANCE = new KeycloakSubsystemAdd();

    KeycloakSubsystemAdd() {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("keycloak-server", Phase.POST_MODULE, 2815, (DeploymentUnitProcessor)new KeycloakServerDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : KeycloakSubsystemDefinition.ALL_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        if (!this.requiresRuntime(context)) {
            return;
        }
        if (!context.isNormalServer()) {
            return;
        }
        ModelNode webContextNode = resource.getModel().get(KeycloakSubsystemDefinition.WEB_CONTEXT.getName());
        if (!webContextNode.isDefined()) {
            webContextNode = KeycloakSubsystemDefinition.WEB_CONTEXT.getDefaultValue();
        }
        String string = webContextNode.asString();
        ServerUtil serverUtil = new ServerUtil(operation);
        serverUtil.addStepToUploadServerWar(context);
        KeycloakAdapterConfigService.INSTANCE.setWebContext(string);
    }
}

